      SUBROUTINE WRPT3B (NPAGE)
C
C                             WRPT3 WRITES THE FINAL CONCENTRATION
C                             OF THE SELECTED QUALITY CONSTITUENTS.
C                             THESE CONSTITUENTS ARE WRITTEN BY REACH
C                             AND BY ELEMENT.
C  UPDATED 6/84 T.WILSON: CORRECTED FORMAT STATEMENTS WHICH
C                         CONTINUED QUOTED STRINGS ACROSS LINES.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
C       INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
CC
        DIMENSION DOMB(7)
CCC
CCC
CCC             NCASI Commentary, WRPT3 - Section I.
CCC                     I. Return to MAIN.
CCC
CCC
CCC
        IF(ISS.EQ.0.AND.PTIME.LT.0.000) RETURN
        LP=LPPG
        DO 500 I=1,NREACH
        NCELR = NCELRH(I)
        WRITE(NJ,6000)
        LP = LP + 2
        DO 500 J=1,NCELR
        LP = LP + 1
        IF(LP.LT.LPPG) GO TO 450
      LP=0
        NPAGE = NPAGE + 1
        WRITE(NJ,6005) NPAGE,VERNUM
        IF(ISS.EQ.0) WRITE(NJ,6007) TIME
        IF(ISS.NE.0) WRITE(NJ,6008)
        WRITE(NJ,6029) (TITLE(II,13),II=3,5),TITLE(15,13)
        IF(METOUT.EQ.0) WRITE(NJ,6030)(TITLE(II,15),II=3,5)
     1 ,TITLE(15,15)
        IF(METOUT.GT.0) WRITE(NJ,6031) (TITLE(II,15),II=3,5)
     1 ,TITLE(15,15)
450     IOR = ICLORD(I,J)
        CALGAE = ALGAE(IOR)*ALPHAO(I)
        TXXX = T(IOR)
        IF(METOUT.GT.0) TXXX = (TXXX-32.0)/1.8
        TOTN = CNH2(IOR) + CNH3(IOR) + CNO2(IOR) + CNO3(IOR)
        TOTP = PORG(IOR) + PHOS(IOR)
        WRITE(NJ,6035) I,J,TXXX,(CONS(IOR,K),K=1,3),DO2(IOR),
     1 BOD(IOR),CNH2(IOR),CNH3(IOR),CNO2(IOR),CNO3(IOR),TOTN,
     2 PORG(IOR),PHOS(IOR),TOTP,COLI(IOR),ANC(IOR),CALGAE
C3P1    OUTPUT INTERFACE - WATER QUALITY VARIABLES  (LCB 6/89)
      OSIM(IOR,36) = TXXX
      DO 501 IO=37,39
      K=IO-36
501   OSIM(IOR,IO) = CONS(IOR,K)
      OSIM(IOR,40) = DO2(IOR)
      OSIM(IOR,41) = BOD(IOR)
      OSIM(IOR,42) = CNH2(IOR)
      OSIM(IOR,43) = CNH3(IOR)
      OSIM(IOR,44) = CNO2(IOR)
      OSIM(IOR,45) = CNO3(IOR)
      OSIM(IOR,46) = TOTN
      OSIM(IOR,47) = PORG(IOR)
      OSIM(IOR,48) = PHOS(IOR)
      OSIM(IOR,49) = TOTP
      OSIM(IOR,50) = COLI(IOR)
      OSIM(IOR,51) = ANC(IOR)
      OSIM(IOR,52) = CALGAE
C3P1
500     CONTINUE
CQ2E + + + + + + +
      IF(LBFLG.EQ.0) GO TO 499
      WRITE(NJ,6036)
6036  FORMAT(/3X,'END OF SYSTEM BOUNDARY CONCENTRATIONS'/)
      XTMPLB = TEMPLB
      IF(METOUT.GT.0) XTMPLB = (XTMPLB-32.0)*5./9.
      SUMNLB = CNH2LB+CNH3LB+CNO2LB+CNO3LB
      SUMPLB = PORGLB + PHOSLB
      CALGLB=ALGLB
C3.0  IF(MODOPT(4).GT.0) CALGLB = ALGLB*ALPHAO(NREACH)
      WRITE(NJ,6037) XTMPLB,(CONSLB(J),J=1,3),DOLB,BODLB,
     1CNH2LB,CNH3LB,CNO2LB,CNO3LB,SUMNLB,PORGLB,PHOSLB,
     1SUMPLB,
     2COLILB,ANCLB,CALGLB
6037  FORMAT(12X,14F7.2,E7.2,2F7.2)
C6037  FORMAT(12X,17F7.2)
499   CONTINUE
CQ2E + + + + + + + +
CQ2E
CQ2E            WRITE ALGAE OUTPUT
CQ2E
        IF(MODOPT(4).EQ.0) GO TO 601
        IF(ISS.EQ.0.AND.PTIME.LT.0.0) RETURN
        LP=LPPG
        COEF = ALPHA3/ALPHA4
        DO 600 I=1,NREACH
        NCELR = NCELRH(I)
        WRITE(NJ,6000)
        LP = LP + 2
        DO 600 J=1,NCELR
        LP = LP + 1
        IF(LP.LT.LPPG) GO TO 550
      LP=0
        NPAGE = NPAGE + 1
        WRITE(NJ,6005) NPAGE,VERNUM
        IF(ISS.EQ.0) WRITE(NJ,6007) TIME
        IF(ISS.NE.0) WRITE(NJ,6008)
        WRITE(NJ,6039)
        IF(METOUT.EQ.0) WRITE(NJ,6040)
        IF(METOUT.GT.0) WRITE(NJ,6041)
550     IOR = ICLORD(I,J)
        CALGAE = ALGAE(IOR)*ALPHAO(I)
        PRRAT = COEF*GROWTH(IOR)/RESPRR(IOR)
        PRNET = (ALPHA3*GROWTH(IOR)-ALPHA4*RESPRR(IOR))*ALGAE(IOR)
        ALGST = AGYSET(IOR)
        IF(METOUT.GT.0)  ALGST = ALGST/3.2808
        EXTCX = EXTC(IOR)
        IF(METOUT.GT.0) EXTCX = EXTCX*3.2808
        WRITE(NJ,6045) IOR,I,J,CALGAE,GROWTH(IOR),RESPRR(IOR),
     1 ALGST,PRRAT,PRNET,PREFN,PRF(IOR),EXTCX,AGFL(IOR),
     2 AGFN(IOR),AGFP(IOR)
C3P1     OUTPUT INTERFACE - ALGAE  (LCB  6/89)
      OSIM(IOR,53) = GROWTH(IOR)
      OSIM(IOR,54) = RESPRR(IOR)
      OSIM(IOR,55) = ALGST
      OSIM(IOR,56) = PRRAT
      OSIM(IOR,57) = PRNET
      OSIM(IOR,58) = PRF(IOR)
      OSIM(IOR,59) = EXTCX
      OSIM(IOR,60) = AGFL(IOR)
      OSIM(IOR,61) = AGFN(IOR)
      OSIM(IOR,62) = AGFP(IOR)
C3P1
600     CONTINUE
CQ2E
CQ2E            WRITE DO OUTPUT
CQ2E
601     CONTINUE
        IF(ISS.EQ.0.AND.PTIME.LT.0.0) RETURN
        LP=LPPG
        NHW = 0
        NWS = 0
        DO 700 I=1,NREACH
        NCELR = NCELRH(I)
        CNCELR = NCELR
        DOIJ = QI(I)/CNCELR*DOI(I)
        WRITE(NJ,6000)
        LP = LP + 2
        DO 700 J=1,NCELR
        LP = LP + 1
        IF(LP.LT.LPPG) GO TO 650
      LP=0
        NPAGE = NPAGE + 1
        WRITE(NJ,6005) NPAGE,VERNUM
        IF(ISS.EQ.0) WRITE(NJ,6007) TIME
        IF(ISS.NE.0) WRITE(NJ,6008)
        WRITE(NJ,6049)
        IF(METOUT.EQ.0) WRITE(NJ,6050)
        IF(METOUT.GT.0) WRITE(NJ,6051)
650     IOR = ICLORD(I,J)
        TXXX = T(IOR)
        IF(METOUT.GT.0) TXXX = (TXXX-32.0)/1.8
        DODEF = DOSAT(IOR)-DO2(IOR)
        DAMIN = 0.0
        IDAM = JDAM(IOR)
        IF(IDAM.NE.0) DAMIN = DAMO2(IDAM)
        IFL = IFLAG(I,J)
        DOMB(1) = DOIJ*86400./VOLSEG(IOR)
        IF(QI(I).LT.0.0)
     *            DOMB(1)=(QI(I)/CNCELR)*DO2(IOR)*86400./VOLSEG(IOR)
        DOMB(2) = XK2(IOR)*DODEF
        DOMB(3) = -K1(IOR)*BOD(IOR)
        DOMB(4) = -(1000./28.317)*SOD(IOR)/DEPTH(IOR)
        DOMB(5) = (ALPHA3*GROWTH(IOR)-ALPHA4*RESPRR(IOR))*ALGAE(IOR)
        DOMB(6) = -ALPHA5*KNH3(IOR)*CNH3(IOR)
        DOMB(7) = -ALPHA6*KNO2(IOR)*CNO2(IOR)
        GO TO (660,670,670,670,670,662,664) IFL
660     NHW = NHW + 1
        DOMB(1) = DOMB(1)+HWFLOW(NHW)*HWDO(NHW)*86400./VOLSEG(IOR)
        GO TO 670
662     NWS = NWS + 1
        DOMB(1) = DOMB(1)+WSFLOW(NWS)*WSDO(NWS)*86400./VOLSEG(IOR)
        GO TO 670
664     NWS = NWS + 1
        DOMB(1) = DOMB(1) + WSFLOW(NWS)*DO2(IOR)*86400./VOLSEG(IOR)
670     CONTINUE
        WRITE(NJ,6055) IOR,I,J,TXXX,DOSAT(IOR),DO2(IOR),DODEF,DAMIN,
     *                 CORDO(IOR),(DOMB(K),K=1,7)
C3P1    OUTPUT INTERFACE - DO MASS BALANCE  (LCB 6/89)
      OSIM(IOR,63) = DODEF
      OSIM(IOR,64) = DAMIN
      OSIM(IOR,65) = CORDO(IOR)
      DO 680 IO=66,72
      K=IO-65
680   OSIM(IOR,IO) = DOMB(K)
C3P1
700     CONTINUE
        RETURN
CQ2E
CQ2E            FORMAT STATEMENTS
CQ2E
6000    FORMAT(/)
 6005 FORMAT( 1H1 /
     * 10X, 25HSTREAM QUALITY SIMULATION, 70X, 19HOUTPUT PAGE NUMBER ,I5
     *   /  10X, 36HQUAL-2E STREAM QUALITY ROUTING MODEL, 51X, A26)
C     *  'EPA/NCASI VERSION')
 6007 FORMAT( / 10X, 'SYSTEM STATUS AFTER', F8.2, ' HOURS OF DYNAMIC',
     1'OPERATION'  )
 6008 FORMAT( 50X, 35H***** STEADY STATE SIMULATION *****  )
C +++++
C6009    FORMAT( / 55X,'** HYDRAULICS SUMMARY **'//
C     1 ' ELE RCH ELE   BEGIN',5X,'END',11X,'POINT',4X,
C     1 'INCR',12X,'TRVL',35X,' BOTTOM',6X,'X-SECT   DSPRSN'/,
C     2 ' ORD NUM NUM',2(5X,'LOC'),4X,'FLOW',4X,'SRCE',4X,'FLOW',5X,
C     3 'VEL',4X,'TIME',4X,'DEPTH',4X,'WIDTH',6X,'VOLUME',
C     4 2(8X,'AREA'),5X,'COEF')
C +++++
6029    FORMAT( / 53X,'** WATER QUALITY VARIABLES **'//' RCH ELE',
     1 14X,'CM-1   CM-2   CM-3',81X,'ANC'/' NUM NUM',7X,'TEMP',
     1 3(3X,A4),'     DO    BOD   ORGN   NH3N   NO2N   NO3N',
     2'  SUM-N   ORGP  DIS-P  SUM-P   COLI',3X,A4,'   CHLA')
6031    FORMAT(14X,'DEG-C',3(3X,A4),10(3X,'MG/L'),
     1' #/100ML',2X,A4,'   UG/L'/)
6030    FORMAT(14X,'DEG-F',3(3X,A4),10(3X,'MG/L'),
     1' #/100ML',2X,A4,'   UG/L'/)
6035    FORMAT(2I4,4X,14F7.2,E7.2,2F7.2)
6039    FORMAT( / 59X,'** ALGAE DATA **'//
     1 78X,'NH3-N',12X,'ALGAE GROWTH RATE ATTEN FACTORS'/
     2 ' ELE RCH ELE',11X,3(4X,'ALGY'),3X,'A P/R',5X,'NET',
     3 9X,'NH3   FRACT   LIGHT'/
     4 ' ORD NUM NUM',7X,'CHLA   GRWTH    RESP    SETT   ',
     5 'RATIO     P-R',8X,'PREF  N-UPTKE  EXTCO',8X,
     6 'LIGHT   NITRGN   PHSPRS')
6040    FORMAT(19X,'UG/L',2(3X,'1/DAY'),3X,'FT/DA',6X,
     1 '*   MG/L-D',3X,2(7X,'*'),5X,'1/FT',3X,3(8X,'*')/)
6041    FORMAT(19X,'UG/L',2(3X,'1/DAY'),3X,'M/DAY',6X,
     1 '*   MG/L-D',3X,2(7X,'*'),6X,'1/M',3X,3(8X,'*')/)
6045    FORMAT(3I4,3X,6F8.2,4X,3F8.2,4X,3F9.2)
6049    FORMAT(/54X,'** DISSOLVED OXYGEN DATA **'//
     1 67X,'COMPONENTS OF DISSOLVED OXYGEN MASS BALANCE (MG/L-DAY)',
     2/' ELE RCH ELE',14X,'DO',14X,'DO',5X,'DAM',5X,'NIT'/
     3 ' ORD NUM NUM    TEMP',5X,'SAT',6X,'DO',5X,'DEF   INPUT',
     4 3X,'INHIB',6X,'F-FNCTN   OXYGN',21X,'NET')
6050    FORMAT(15X,'DEG-F',4(4X,'MG/L'),4X,'FACT',8X,'INPUT',
     1 3X,'REAIR   C-BOD     SOD     P-R   NH3-N   NO2-N'/)
6051    FORMAT(15X,'DEG-C',4(4X,'MG/L'),4X,'FACT',8X,'INPUT',
     1 3X,'REAIR   C-BOD     SOD     P-R   NH3-N   NO2-N'/)
6055    FORMAT(3I4,6F8.2,5X,7F8.2)
        END
