      SUBROUTINE ZEROP(NP,INDEX,MTYPE,LUP,IZERO)
C
C     THIS SUBROUTINE EXAMINES THE NUMERICAL VALUE OF EACH INPUT
C     VARIABLE.  IF THE VALUE IS SUCH THAT THE INPUT VARIABLE IS
C     NOT USED IN THE SIMULATION (I.E. ZERO, OR 1.0 IN THE CASE OF A
C     TEMPERATURE COEFFICIENT), THE INPUT VARIABLE IS PURGED FROM THE
C     UNCERTAINTY ANALYSIS (FOEA AND MCS).
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
C
C     TEST EACH INPUT VARIABLE BY GENERIC TYPE.  RETURN FLAG IZERO
C                0=PURGE,  1=KEEP
C
      IZERO=0
      LUP=NREACH
      GO TO (110,120,130,140,150,160,170) MTYPE
C
C       GLOBAL VARIABLES
C
110   CONTINUE
      LUP=1
CCC IF statements reversed to correct logic flow
CCC 09/02/87 - DWD CSC for US EPA
      IF(INDEX.GE.48) GO TO 115
      IF(INDEX.GT.28) GO TO 112 
      TEMPI = GL(INDEX)
      IF(ABS(TEMPI).GT.1.0E-8) IZERO=1
      GO TO 98
112   TEMPI=GL(INDEX)
      IF(ABS(TEMPI).GT.1.0000) IZERO=1
      GO TO 98
115   IZERO=1
      GO TO 98
C
C       HYDRAULIC/CLIMATOLOGICAL VARIABLES
C
120   CONTINUE
      DO 122 I=1,NREACH
      TEMPI = HY(I,INDEX)
      IF(ABS(TEMPI).GT.1.0E-8) IZERO=1
122   CONTINUE
      GO TO 98
C
C       REACTION COEFFICIENTS
C
130   CONTINUE
      IF(INDEX.GE.23) GO TO 135
      DO 132 I=1,NREACH
      TEMPI = RX(I,INDEX)
      IF(ABS(TEMPI).GT.1.0E-8) IZERO=1
132   CONTINUE
      GO TO 98
135   CONTINUE
      IZERO=1
      GO TO 98
C
C       INCREMENTAL FLOW CONDITIONS
C
140   CONTINUE
      DO 142 I=1,NREACH
      TEMPI = FI(I,INDEX)
      IF(ABS(TEMPI).GT.1.0E-8) IZERO=1
142   CONTINUE
      GO TO 98
C
C       HEADWATER CONDITIONS
C
150   CONTINUE
      LUP=NHWTRS
      DO 152 I=1,NHWTRS
      TEMPI = FH(I,INDEX)
      IF(ABS(TEMPI).GT.1.0E-8) IZERO=1
152   CONTINUE
      GO TO 98
C
C       POINT LOAD CONDITIONS
C
160   CONTINUE
      LUP=NWASTE
      DO 162 I=1,NWASTE
      TEMPI = FP(I,INDEX)
      IF(ABS(TEMPI).GT.1.0E-8) IZERO=1
162   CONTINUE
      GO TO 98
C
C       DAM CONDITIONS
C
170   CONTINUE
      LUP=NDAM
      DO 172 I=1,NDAM
      IF(ADAM(I).GT.1.0) IZERO=1
      IF(BDAM(I).GT.1.0) IZERO=1
      IF(FDAM(I).LT.1.0) IZERO=1
172   CONTINUE
C
98    CONTINUE
      RETURN
      END
