{ --------------------------------------------------------------------------- }
{ -- SCRNUTIL.PAS  contains screen I/O routines.  It draws heavily ---------- }
{ -- on textutil.pas.  Although it contains some assumptions particular to -- }
{ -- SMPTOX3 it can easily be adapted to other problems.  ------------------- }
{ --------------------------------------------------------------------------- }


{ ----------------------- Created 5/29/90 by DC ---------------------------- }
{ ------------------------- Modification lists ----------------------------- }

  { 5/30/90  Still Debugging - DC }
  { 5/31/90  Corrected Bottom_text for reach_screen - DC }
  { 6/12/90  Added bottom_text for sense_screen - DC }
  { 7/3/90   Fixed some bugs in bottom_text - DC }
  { 8/7/90   Adding a header_width = 3 option - DC }
  { 10/15/90 Added the ability to pass starting value to edit_screen - DC }

{ -------------------------------------------------------------------------- }
{ -------------------------------------------------------------------------- }
unit ScrnUtil;

interface

uses crt,textutil;

procedure Clear_Screen_Inputs; { Sets up for call to edit screen }
procedure set_normal_returns;  { Sets return values to F1, F2, F3, F4, F10, and Escape }
function edit_screen( title: textstr;
                      last_x,last_y: integer;
                      skip_lines:boolean;
                      var xpos:integer;var ypos : integer) : integer;
                      { paints the screen and takes input }

procedure message(mes1,mes2 : textstr;first_time :Boolean);
                            { gives I'm thinking message }

const

  Max_x_headers = 10;     { Maximum number of x input fields }
  Max_y_headers = 50;     { Maximum number of y input fileds }
  Max_string = 50;        { Maximum size in columns of input field }

  Number_Xlines = 78;
  Number_Ylines = 17;

  Valid_Return_keys = 15; { Maximum number of keys that can exit a screen (+2 for 0, and -1) }
  Upstream_Screen = 1;    { Return key values }
  Effluent_Screen = 2;    { Return key values }
  Reach_Screen = 3;       { Return key values }
  Observed_Screen = 4;    { Return key values }
  Page_up = 5;            { Return key values }
  Page_down = 6;          { Return key values }
  sense_Screen    = 7;    { Return Key values }
  output_Screen = 8;      { Return key values }
  Info_Screen = 9;        { Return key values }
  Quit_Input = 10;        { Return key values }
  Escape = -1;            { Return key values }
  standards_screen = 11;  { Screen_name but not a return key value }
  modify_screen = 12;     { Screen_name but not a return key value }
  RRepeat = 13;            { Return key values }

type
  sfields = string[Max_string];
  screen_inputs = array[0..Max_x_headers,0..Max_y_headers] of sfields;
var

     { Global variables which describe input screens when used by edit_screen }
  xheaders : array[0..Max_x_headers] of sfields;                        { header strings running along the x direction }
  yheaders : array[0..Max_y_headers] of sfields;                        { header strings running along the y direction }
  map_inputs : array[0..Max_x_headers,0..Max_y_headers] of boolean;     { a map of which fields are active, true is active }
  number_inputs : array[0..Max_x_headers,0..Max_y_headers] of boolean;  { a map of which fields contain number inputs, }
                                                                        { true shows a number input }
  xdata_width  : array[0..Max_x_headers] of integer;                    { width of data in columns }
  screen_data  : ^screen_inputs;                                        { data shown on screen }
  Screen_type  : integer;                                               { iteration variable holding a description of the
                                                                          screen }
  Valid_Returns : array[-1..Valid_Return_Keys] of Boolean;              { Flag for return keys }
  Header_Width : integer;                                               { Can be 0,1,2 }
  NO_MOVE :  Boolean;                                                   { equals true if user can't move }



implementation

  { -------------------------------------------- }
  { -- Message prints the progress report ------ }
  { -------------------------------------------- }
  procedure message(mes1,mes2 : textstr; first_time :Boolean);
  var i, j : integer;
      buf  : string[3];
  begin
       if first_time then
       begin
            ClearScreen;
            cursor(off);
            j := length(mes1);
            i := trunc(j/2)+1;
            linetype := 2;
            textbox(12,10,15,70);
            linetype := 1;
            textbox(1,1,25,79);
       end;
       if mes1 <> '' then
       begin
            TextClear(13,11,13,69);
            j := length(mes1);
            i := trunc(j/2)+1;
            showstring(Mes1,40-i+1,13,j,OFF);
       end;
       if mes2 <> '' then
       begin
            TextClear(14,11,14,69);
            j := length(mes2);
            i := trunc(j/2)+1;
            showstring(Mes2,40-i+1,14,j,OFF);
       end;

  end;

  { ------------------------------------------------------------------------ }
  { -- In general, a few guide lines for using ScrnUtil:                  -- }
  { --   1) Memory must be allocated of screen_data, failure to do so may -- }
  { --       have "unpredictable" results.                                -- }
  { --   2) Call Clear_Screen_Inputs to initialize all needed variables   -- }
  { --   3) Fill xheaders and yheaders with desired x and y labels        -- }
  { --   4) Choose proper values for xdata_widths.                        -- }
  { --   5) Set header_width if desired                                   -- }
  { --   6) Fill screen data with appropiate values                       -- }
  { --   8) Set valid_returns (call set_normal_returns if F1..F4, F10     -- }
  { --       are alright)                                                 -- }
  { --   9) Set number_inputs[] := False for all full text responses      -- }
  { --   10) Call edit_screen.                                            -- }
  { ------------------------------------------------------------------------ }


  { ----------------------------------------------------------------------- }
  { -- Clear_Screen_Inputs sets global variables to proper values --------- }
  { ----------------------------------------------------------------------- }

  procedure Clear_Screen_Inputs;
  var i,j : integer;
  begin
       for i := 0 to Max_x_headers do
       begin
           xheaders[i] := '';
           xdata_width[i] := 0;
           for j := 0 to Max_y_headers do
           begin
                if (i=0) or (j=0) then map_inputs[i,j] := FALSE
                else map_inputs[i,j] := TRUE;
                number_inputs[i,j] := TRUE;
                screen_data^[i,j] := '';
           end;
       end;
       for j := 0 to max_y_headers do
           yheaders[j] := '';

       for i := 0 to valid_return_keys do
           valid_returns[i] := FALSE;
       valid_returns[Escape] := TRUE;
       header_width := 1;
       No_Move := FALSE;

  end;  { end clear_screen_inputs }

{ --------------------------------------------------------------------------- }
{ -- edit_screen is a generalized procedure to display and input data.     -- }
{ -- Title is the screen title                                             -- }
{ -- last_x is the number of the last x field to be edited                 -- }
{ -- last_y is the number of the last y field to be edited                 -- }
{ -- Skip_lines is true if lines are to be skipped between y fields        -- }
{ -- xpos and ypos correspond to the starting positions for x and y fileds -- }
{ -- Return value is                                                       -- }
{ --        Upstream_Screen if f1 is pressed;                              -- }
{ --        Effluent_Screen if f2 is pressed;                              -- }
{ --        Reach_Screen    if f3 is pressed;                              -- }
{ --        Observed_Screen if f4 is pressed;                              -- }
{ --        Quit_Input      if f10 is pressed;                             -- }
{ --        Page_up         if Page_up is pressed;                         -- }
{ --        Page_down       if Page_down is pressed;                       -- }
{ --        Escape          if Esc is pressed;                             -- }
{ --------------------------------------------------------------------------- }

  function edit_screen( title: textstr;
                        last_x,last_y: integer;
                        skip_lines:boolean;
                        var xpos:integer; var ypos:integer) : integer;

  var
     i,ii,j,jj,count      : integer;
     x_stops,y_stops   : array[0..10] of integer;  { each stop represents the number fields that fit on a screen }
     nx_stops,ny_stops : integer;                  { number of stops }
     what_next         : integer;                  { holder for return value }
     ysk,xsk           : integer;                  { position for stops }
     ysize,xsize       : integer;                  { screen size }
     time_to_go        : boolean;                  { flag for end of procedure }
     xscnpos           : integer;
     yscnpos           : integer;
     buf               : string;
     DI,DJ             : integer;
     newx,newy         : integer;
     newxsk,newysk     : integer;
     flag              : Boolean;
     N_Ylines,da       : integer;

       { ---------------------------------------- }
       procedure determine_screen_size;
       var i : integer;
       begin
            xsize := xdata_width[0];
            for i := x_stops[xsk-1]+1 to x_stops[xsk] do
                xsize := xdata_width[i] + xsize;
            xsize := xsize;


             ysize := 0;
             j := y_stops[ysk] - y_stops[ysk-1];
             if skip_lines then ysize := j*2 + 2
                else ysize := j + 3;

       end;  { end determine screen size }

       { ------------------------------------------------- }

       procedure Bottom_Text(Screen:integer);
       begin

            TextLineH(25,2,79);
            case Screen of
                 sense_Screen,
                 modify_screen:
                 begin
                      showstring('Enter text and Press     to continue',23,25,34,off);
                      showstring('F10',44,25,3,ON);
                 end;

                 Output_Screen :
                 begin
                      showstring('Use PgUp and PgDn to see other data',22,24,34,off);
                      showstring('Press     to continue',30,25,21,off);
                      showstring('F10',36,25,3,ON);
                 end;

                 Upstream_Screen,
                 Info_Screen,
                 observed_screen,
                 reach_screen,
                 effluent_screen :
                 begin
                      showstring('  -Upstream    -Effluent    -Reach    -Observed    -Info     -Quit'
                                    ,5,25,59,off);
                      showstring('F1',5,25,2,ON);
                      showstring('F2',18,25,2,ON);
                      showstring('F3',31,25,2,ON);
                      showstring('F4',41,25,2,ON);
                      showstring('F5',54,25,2,ON);
                      showstring('F10',63,25,3,ON);
                      if Screen = reach_screen then
                           showstring('Use PgUp and PgDn to get other Reaches',22,23,34,off);
                      if Screen = effluent_screen then
                         showstring('Use PgUp and PgDn to get other Discharges',18,23,34,off);
                 end;

                 standards_screen:
                 begin
                      showstring('   - To Change Discharge         - To Run Simulation',10,25,30,off);
                      showstring('F1',10,25,2,ON);
                      showstring('F10',39,25,3,ON);
                 end;

            end; { end case }
       end;  { end bottom text }

       { ---------------------------------------- }
       function xscn(n:integer) : integer;
       var i,j : integer;
       begin
            j := xdata_width[0];
            for i := x_stops[xsk-1]+1 to n-1 do
                j := j + xdata_width[i];
            xscn := j+3;
       end;

       { ---------------------------------------- }
       function yscn(n:integer) : integer;
       var j : integer;
       begin
            if skip_lines then j := (n-y_stops[ysk-1]-1) * 2
               else j := n-y_stops[ysk-1]-1;
            if j < 0 then j := -2;  { silly kludgy patch, but it will do -DC}
            yscn := j + 5 + header_width;
       end;
       { ---------------------------------------- }

       procedure show_screen;
       var i,j,jj : integer;
           buf : sfields;
       begin
            j := length(title);
            i := trunc(j/2)+1;
            ClearScreen;
            linetype := 2;
            determine_screen_size;
            textbox(3,1,2+header_width+ysize,2+xsize);
            textbox(1,1,3,2+xsize);
            showstring(title,3,2,j,off);
            linetype := 1;

            case header_width of
                 0 :
                      for i:= x_stops[xsk-1]+1 to x_stops[xsk] do
                           TextLineV(xscn(i)-1,3,2+header_width+ysize);
                 1 :
                 begin
                      showstring(xheaders[0],xscn(0)-xdata_width[0],yscn(0),xdata_width[0]-1,off);

                      for i:= x_stops[xsk-1]+1 to x_stops[xsk] do
                      begin
                           showstring(xheaders[i],xscn(i),yscn(0),xdata_width[i]-1,off);
                           TextLineV(xscn(i)-1,3,2+header_width+ysize);
                      end;

                      TextLineH(4+header_width,1,2+xsize);
                 end;
                 2 :
                 begin
                      showstring(xheaders[0],xscn(0)-xdata_width[0],yscn(0),xdata_width[0]-1,off);

                      for i:= x_stops[xsk-1]+1 to x_stops[xsk] do
                      begin
                           if xdata_width[i] <= length(xheaders[i]) then
                           begin
                                buf := xheaders[i];
                                da := pos(' ' ,buf);
                                while ( da <= xdata_width[i]) and (da > 0) do
                                begin
                                      j := pos(' ',buf);
                                      buf[pos(' ',buf)] := 'l';
                                      da := pos(' ' ,buf);
                                end;
                                buf := copy(xheaders[i],1,j-1);
                                showstring(buf,xscn(i),yscn(0)-1,xdata_width[i]-1,off);
                                buf := copy(xheaders[i],j+1,xdata_width[i]);
                                showstring(buf,xscn(i),yscn(0),xdata_width[i]-1,off);
                           end
                           else
                               showstring(xheaders[i],xscn(i),yscn(0),xdata_width[i]-1,off);
                           TextLineV(xscn(i)-1,3,2+header_width+ysize);
                      end;

                      TextLineH(4+header_width,1,2+xsize);
                 end;
                 3 :
                 begin
                      showstring(xheaders[0],xscn(0)-xdata_width[0],yscn(0),xdata_width[0]-1,off);

                      for i:= x_stops[xsk-1]+1 to x_stops[xsk] do
                      begin
                           if xdata_width[i] <= length(xheaders[i]) then
                           begin
                                buf := xheaders[i];
                                da := pos(' ' ,buf);
                                while ( da <= xdata_width[i]) and (da > 0) do
                                begin
                                     j := da;
                                     buf[j] := 'l';
                                     da := pos(' ',buf);
                                end;
                                buf := copy(xheaders[i],1,j-1);
                                showstring(buf,xscn(i),yscn(0)-2,xdata_width[i]-1,off);
                                buf := copy(xheaders[i],j+1,length(xheaders[i])-j);
                                if xdata_width[i] <= length(buf) then
                                begin
                                     da := pos(' ',buf);
                                     while ( da <= xdata_width[i]) and (da > 0) do
                                     begin
                                          jj := da;
                                          buf[jj] := 'l';
                                          da := pos(' ',buf);
                                     end;
                                     buf := copy(xheaders[i],j+1,jj-1);
                                     showstring(buf,xscn(i),yscn(0)-1,xdata_width[i]-1,off);
                                     buf := copy(xheaders[i],jj+j+1,xdata_width[i]);
                                     showstring(buf,xscn(i),yscn(0),xdata_width[i]-1,off);
                                end
                                else
                                    showstring(buf,xscn(i),yscn(0)-1,xdata_width[i]-1,off);
                           end
                           else
                               showstring(xheaders[i],xscn(i),yscn(0),xdata_width[i]-1,off);
                           TextLineV(xscn(i)-1,3,2+header_width+ysize);
                      end;

                      TextLineH(4+header_width,1,2+xsize);
                 end;
            end; { end case }

            for i:= y_stops[ysk-1]+1 to y_stops[ysk] do
                 showstring(yheaders[i],xscn(0)-xdata_width[0],yscn(i),xdata_width[0]-1,off);


            for i:= x_stops[xsk-1]+1 to x_stops[xsk] do
                 for j:= y_stops[ysk-1]+1 to y_stops[ysk] do
                      showstring(screen_data^[i,j],xscn(i),yscn(j),xdata_width[i]-1,off);

            Bottom_text(screen_type);

       end;  { end show_screen }



       { ---------------------------------------- }

  begin   { begin edit_screen }

       what_next := 0;
       Flag := FALSE;
       cursor(OFF);
       ClearScreen;

       j := 0;
       count := 0;
       x_stops[0] := 0;
       nx_stops := 1;
       for i := 0 to last_x do
       begin
            count := count + xdata_width[i];

            if count > Number_Xlines then
            begin
                 j := 0;
                 count := xdata_width[0];
                 x_stops[nx_stops] := i-1;
                 nx_stops := nx_stops + 1;
            end;
       end;
       x_stops[nx_stops] := last_x;

       count := 0;
       y_stops[0] := 0;
       ny_stops := 1;
       if skip_lines then N_Ylines := Number_Ylines + 1
       else N_Ylines := Number_Ylines -1;
       for i := 1 to last_y do
       begin
            if (skip_lines) and (i<>last_y) then
               count := count + 2
            else count := count+1;

            if count > N_Ylines then
            begin
                 y_stops[ny_stops] := i-1;
                 ny_stops := ny_stops + 1;
                 count := 1;
            end;
       end;
       y_stops[ny_stops] := last_y;

       xsk := 1;
       ysk := 1;

       for i := 1 to last_x do
           for j := 1 to last_y do
           begin
                ii := trunc( (xdata_width[i] - length(screen_data^[i,j])) / 2);
                while ii > 0 do
                begin
                     screen_data^[i,j] := ' ' + screen_data^[i,j];
                     ii := ii -1;
                end;
           end;

       for i := 0 to last_x do
       begin
            ii := trunc( (xdata_width[i] - length(xheaders[i])) / 2);
            while ii > 0 do
            begin
                 xheaders[i] := ' ' + xheaders[i];
                 ii := ii -1;
            end;
       end;

       show_screen;

       if (xpos < 1) or (xpos > last_x) then xpos := 1;
       if (ypos < 1) or (ypos > last_y) then ypos := 1;

       if not no_move then
          showstring(screen_data^[xpos,ypos],xscn(xpos),yscn(ypos),xdata_width[xpos]-1,On);


       time_to_go := FALSE;

       while not time_to_go do
       begin
            di := 0; dj := 0;
            getchar;

            if (Code > 32) and (Ch in ['0'..'9','-','+','A'..'Z','a'..'z',' ','.']) then
            begin
                 if number_inputs[xpos,ypos] then
                    GetString(Buf,xscn(xpos),yscn(ypos),xdata_width[xpos]-1,['0'..'9','+','-','.','e','E'])
                 else
                    GetString(Buf,xscn(xpos),yscn(ypos),xdata_width[xpos]-1,[' '..'z']);
                 if Code <> 27 then
                 begin
                      ii := trunc( (xdata_width[xpos] - length(buf) -1) / 2);
                      for jj := 1 to ii do
                          buf := ' ' + buf;
                      screen_data^[xpos,ypos] := buf;
                 end;
            end;

            case Code of

                 13 : if not no_move then DJ := 1;
                -19 :
                      if valid_returns[RRepeat] then
                      begin
                           time_to_go := TRUE;
                           what_next := RRepeat;
                      end;

                -59 :
                      if valid_returns[Upstream_Screen] then
                      begin
                           time_to_go := TRUE;
                           what_next := Upstream_Screen;
                      end;
                 -60:
                      if valid_returns[Effluent_Screen] then
                      begin
                           time_to_go := TRUE;
                           what_next := Effluent_Screen;
                      end;
                 -61:
                      if valid_returns[Reach_Screen] then
                      begin
                           time_to_go := TRUE;
                           what_next := Reach_Screen;
                      end;
                 -62:
                      if valid_returns[Observed_Screen] then
                      begin
                           time_to_go := TRUE;
                           what_next := Observed_Screen;
                      end;
                 -63:
                      if valid_returns[Info_Screen] then
                      begin
                           time_to_go := TRUE;
                           what_next := Info_Screen;
                      end;
                 -68:
                      if valid_returns[Quit_Input] then
                      begin
                           time_to_go := TRUE;
                           what_next := Quit_Input;
                      end;
                  27 :
                      if valid_returns[Escape] then
                      begin
                           time_to_go := TRUE;
                           what_next := Escape;
                      end;

                 -73:
                      if valid_returns[Page_Up] then
                      begin
                           time_to_go := TRUE;
                           what_next := Page_Up;
                      end;
                 -81:
                      if valid_returns[Page_Down] then
                      begin
                           time_to_go := TRUE;
                           what_next := Page_Down;
                      end;
                 -72: if not no_move then DJ := -1;
                 -75: if not no_move then  DI := -1;
                 -77: if not no_move then DI := 1;
                 -80: if not no_move then DJ := 1;
            end;

            if (DI <> 0) or (DJ <> 0) then
            begin
                 newx := xpos + di; newy := ypos + dj;

                 if newx > last_x then newx := 1;
                 if newy > last_y then newy := 1;
                 if newx < 1 then newx := last_x;
                 if newy < 1 then newy := last_y;

                 while (not map_inputs[newx,newy])
                   and (newx<last_x) and (newy<last_y)
                   and (newx>0) and (newy>0)
                   do
                    if di > 0 then newx := newx + 1
                       else if di < 0 then newx := newx -1
                            else if dj > 0 then newy := newy + 1
                                 else newy := newy -1;

                 if ( not map_inputs[newx,newy])
                 or (newx>last_x) or (newy>last_y)
                 or (newx<1) or (newy<1) then
                 begin
                      newx := xpos;
                      newy := ypos;
                 end;

                 newxsk := xsk; newysk := ysk;

                 while(newx > x_stops[newxsk]) and (newxsk<nx_stops) do
                            newxsk := newxsk + 1;
                 while(newy > y_stops[newysk]) and (newysk<ny_stops) do
                            newysk := newysk + 1;
                 while(newx <= x_stops[newxsk-1]) and (newxsk>1) do
                            newxsk := newxsk - 1;
                 while(newy <= y_stops[newysk-1]) and (newysk>1) do
                            newysk := newysk - 1;

                 if (newxsk <> xsk) or (newysk <> ysk) then
                 begin
                      showstring(screen_data^[xpos,ypos],xscn(xpos),yscn(ypos),xdata_width[xpos]-1,off);
                      xsk := newxsk; ysk := newysk;
                      Show_Screen;
                      flag := TRUE;
                 end;

                 if (newx <> xpos) or (newy <> ypos) then
                 begin
                      if not flag then
                         showstring(screen_data^[xpos,ypos],xscn(xpos),yscn(ypos),xdata_width[xpos]-1,off);
                      flag := FALSE;
                      xpos := newx; ypos := newy;
                      showstring(screen_data^[xpos,ypos],xscn(xpos),yscn(ypos),xdata_width[xpos]-1,on);
                 end;

            end;

       end;  { end while (its time to go) }

       edit_screen := what_next;
  end;  { end edit_screen }



  { ------------------------------------------------------------------------ }
  { -- Set_normal_returns makes f1, f2, f3, f4,f5,f10 all valid return keys -- }
  { ------------------------------------------------------------------------ }
  procedure set_normal_returns;
  begin
       valid_returns[Upstream_Screen] := True;
       valid_returns[Effluent_Screen] := True;
       valid_returns[Reach_Screen] := True;
       valid_returns[Observed_Screen] := True;
       valid_returns[Info_Screen] := True;
       valid_returns[Quit_Input] := True;
  end;


end. { end implementation }