{ -------------------------------------------------------------------------- }
{ -- STX3.PAS is the main file for the SMPTX3 model.  It contains the  ----- }
{ -- program driver and setup. --------------------------------------------- }
{ -------------------------------------------------------------------------- }


{ ----------------------- Created 5/28/90 by DC ---------------------------- }
{ ------------------------- Modification lists ----------------------------- }

{ 5/29/90  Adding more functionality - DC }
{ 6/4/90   Added calls to save and load files - DC }
{ 6/5/90   Added call to graphics - DC }
{ 6/8/90   Added Command line file input, and some safe guards - DC }
{ 6/11/90  Added double bars between choices - DC }
{ 7/12/90  Added "Save Changes?" - DC }
{ 1/3/91   Adding ability to model in fashion of SMPTOX, and SMPTOX2 - DC }
{ 9/3/91   Adding version Number - DC }
{ 9/4/91   Fixing exiting -DC }
{ 10/10/91 Changing version to SMPTOX3 2.0 - DC }
{ 02/12/92 Remove printer driver TPUS from main program }

{ -------------------------------------------------------------------------- }
{ -------------------------------------------------------------------------- }

program stx3;


uses
     stx3_run,        { The heart of the model }
     stx3_ana,        { Analytical solution to the model }
     stx3_var,        { Smptox3 model variables }
     stx3_msc,        { Smptox3 miscellaneous variables }
     stx3_scr,        { Descriptions of Smptox3 I/O screens }
     stx3_grp,        { Graphics routines }
     stx3_fil,        { Routines for Smptox3 file handling }
     stx3_fun,        { Commonly used math functions }
     ScrnUtil,        { General Screen routines }
     TextUtil,        { General Text routines }
     graph,           { Turbo's graphics routines }
     drivers,         { Turbo BGI drivers }
     crt,             { Turbo stdio library }
     dos;             { Turbo's DOS library }

{
  The following drivers are used in STX3_GRP for printer graphics
  support and are listed here only for informational purposes.
  Please look at STX3_GRP.PAS for comments about including printer
  support for the program.
}
{     graphadd,        { Printer graphics }
{     lq,              { Epson LQ Printer Driver }
{     fx,              { Epson fx Printer Driver }
{     lj,              { HP Laser Jet Printer Driver }

{ ----------------------------------------------------- }
{ ---- Prompts user to save file ---------------------- }
{ ----------------------------------------------------- }

function save_changes : integer;
var i : integer;
    buf : textstr;
begin
     i := 1;
     if pos('*',infile_name) > 0 then infile_name := 'TEMP.ST3';
     buf := 'Save Changes to '+infile_name+'/'+'YES//NO';
     getmenuchoice(i,buf);
     if i = 1 then save_data(infile_name);
     save_changes := i;
end;

var
    i,j             : integer;
    dirinfo         : SearchRec;
    inn             : text;
    olddir,od,fo    : string[255];
    outf,outd       : textstr;
    d               : dirstr;
    n               : namestr;
    e               : extstr;
    simulation_run  : boolean;
    many_run        : boolean;
    file_loaded     : boolean;
    changes_made    : boolean;
    drive           : char;

begin                      { main program }

  if (RegisterBGIdriver(@CGADriverProc) < 0) or
     (RegisterBGIdriver(@EGAVGADriverProc) < 0) or
     (RegisterBGIdriver(@HercDriverProc) < 0) then
    begin
         Error_Message('Can not register Graphics Drivers');
         Halt;
    end;

    first_time_f := TRUE;
    message('S M P T O X 3     V E R S I O N  2.0','',TRUE);

    setup_variables;

    getdir(0,olddir);
    drive := olddir[1];
    simulation_run := FALSE;
    file_loaded := FALSE;

    if Paramcount > 0  then
    begin
         infile_name := Paramstr(1);
         fsplit(infile_name,d,n,e);

         findfirst(d,directory,dirinfo);
         if dosError = 0 then
         begin
              chdir(d);
              in_directory := d;
         end
         else
             in_directory := olddir;

         infile_name := n+e;
         findfirst(infile_name,Archive,dirinfo);
         i := pos('*',infile_name);
         j := pos('?',infile_name);
         if (DosError = 0) and (i=0) and (j=0) then
         begin
              load_data(infile_name);
              file_loaded := TRUE;
         end
         else infile_name := '*.st3';
    end
    else
    begin
         findfirst('Smptox3.fil',AnyFile,dirinfo);
         if dosError = 0 then
         begin
              od := in_directory;
              assign(inn,'Smptox3.fil');
              reset(inn);
              readln(inn,in_directory);
              readln(inn,infile_name);
              close(inn);

              findfirst(in_directory,directory,dirinfo);
              if DosError = 0 then
                 chdir(in_directory)
              else in_directory := od;

              findfirst(infile_name,Archive,dirinfo);
              i := pos('*',infile_name);
              j := pos('?',infile_name);
              if (DosError = 0) and (i=0) and (j=0) then
              begin
                   load_data(infile_name);
                   file_loaded := TRUE;
              end
              else infile_name := '*.st3';
         end
         else
         begin
              in_directory := olddir;
              infile_name := '*.st3';
         end;
    end; { end else }



    in_directory[1] := drive;
    changes_made := FALSE;
    many_run := FALSE;
    graph_type := 0;
    nplots := 0;
    max_plots := 0;
    first_time_f := FALSE;

    i := 1;
    while i <> 9 do
    begin
          getmenuchoice(i,'SMPTOX3 MAIN MENU/'+
                          'Read Inputs From File/'+
                          'Save Inputs To File/'+
                          'Enter \ Modify Model Inputs//'+
                          'Run Single Simulation/'+
                          'Run Multiple Simulations//'+
                          'View Tabular Output/'+
                          'View Graphics Output/'+
                          'Print Results//'+
                          'Quit');
          case i of

               1 : begin
                        fo := infile_name;
                        od := in_directory;
                        infile_name := '*.st3';
                        if get_file_name(in_directory,infile_name,In_Put) <> '' then
                        begin
                             drive := in_directory[1];
                             if infile_name[1] = '&' then
                             begin
                                  infile_name := copy(infile_name,2,length(infile_name)-1);
                                  fo := infile_name;
                                  od := in_directory;
                                  setup_variables;
                                  infile_name := fo;
                                  in_directory := od;
                             end
                             else
                                  load_data(infile_name);
                             file_loaded := TRUE;
                             simulation_run := FALSE;
                             changes_made := FALSE;
                        end
                        else
                        begin
                             infile_name := fo;
                             in_directory := od;
                        end;
               end;

               2 : if get_file_name(in_directory,infile_name,Out_Put) <> '' then
                   begin
                        drive := in_directory[1];
                        save_data(infile_name);
                        changes_made := FALSE;
                   end;

               3 : begin
                        edit_river_data;
                        changes_made := TRUE;
               end;

               4 : if file_loaded then
                   begin
                        run_model;
                        Simulation_run := TRUE;
                   end;

               5 : begin
                        if changes_made then j := save_changes;
                        if j <> -1 then changes_made := FALSE;
                        many_model(file_loaded,many_run);
                        many_run := TRUE;
                        Simulation_run := TRUE;
               end;

               6 : if simulation_run then
                      view_table_output(outfile_name);

               7 : if simulation_run then
                      show_graph(graph_type);

               8 : if simulation_run then
                      print_data;

               -1,9 : Begin
                        j := 1;
                        if changes_made then j := save_changes;
                        if j = -1 then
                           i := 1
                        else i := 9;
               end;

          end; { end case }

    end;  { end while }


    chdir(olddir);
    assign(inn,'Smptox3.fil');
    rewrite(inn);
    writeln(inn,in_directory);
    writeln(inn,infile_name);
    close(inn);

    if nplots <> 0 then
    begin
         if graph_type = many_plot then
            for i := 1 to nplots do
                dispose(graph_buf[i])
         else
             if graph_type = Sensitivity_plot then
                for i := 1 to max_plots do
                    dispose(graph_buf[i])
             else dispose(graph_buf[1]);
    end;

    clearscreen;
    cursor(on);

end.  { end main program }

