{ -------------------------------------------------------------------------- }
{ -- STX3_FIL contains file I/O  routines for the SMPTOX3 model. This unit - }
{ -- is called by STX3.PAS but calls on routines inn textutil and    -------- }
{ -- ScrnUtil for screen I/O. ---------------------------------------------- }
{ -------------------------------------------------------------------------- }


{ ----------------------- Created 5/31/90 by DC ---------------------------- }
{ ------------------------- Modification lists ----------------------------- }

{ 6/4/90  Beginning to add functionality -DC }
{ 6/5/90  Enhancing Get_file_name - DC  }
{ 6/6/90  Still Debugging Get_File_Name - DC }
{ 6/7/90  Finished debugging Get_File_Name -DC }
{ 6/14/90 Adding Observational data - DC }
{ 8/1/90  Adding Discharge name - DC }
{ 9/12/90 Fix spacing for printout of effluent pollutant - Tad }
{ 1/3/91  Added model complexity variable - DC }
{ 1/25/91 Attempting to make 40 reach version - DC }
{ 10/10/91 Adding reading and writing messages - DC }
{ 10/17/91 Fixing printing bugs from upstream and observations - DC }

{ -------------------------------------------------------------------------- }
{ -------------------------------------------------------------------------- }


unit stx3_fil;

interface

uses crt,dos,printer,textutil,stx3_var,stx3_msc,scrnutil,stx3_scr;

function get_file_name(var director,filename : textstr;switch : integer ) : textstr;
                                                          { gets a file name }
function get_outfile_name(infile: textstr): textstr;      { gets an outfile name }
procedure Save_data( filename : textstr);                 { Saves data to disk }
procedure load_data( filename : textstr);                 { loads data to disk }
procedure print_data;                                     { Writes input and output to a file  or printer}

implementation

{ -------------------------------------------------------------------------- }
{ -- get_file_name allows the user to enter a file name or search the disk - }
{ -- for previously saved files.  The function returns the name of the ----- }
{ -- desired file.  Directory and filename are the directory and file name-- }
{ -- that were last searched for.  Filename may contain wildcards. --------- }
{ -- The switch variable is In_Put if loading a file, Out_put if saving a -- }
{ -- file. ----------------------------------------------------------------- }
{ -------------------------------------------------------------------------- }

  type
      file_fields = array[1..2,0..50] of string[40];   { used to store file and directory names }

  function get_file_name(var director,filename : textstr; switch :integer) : textstr;
  var
      fields                 : integer;
      field                  : ^file_fields;  { 1 for name, 2 for directory }
      temp                   : searchRec;     { used by find first }
      num                    : array[1..2] of integer;
      top                    : array[1..2] of integer;
      offset                 : array[1..2] of integer;
      dj,df                  : integer;
      needs_paint            : boolean;
      buf                    : string;
      d                      : dirstr;
      n                      : namestr;
      e                      : extstr;
      pout                   : text;

  { --- Clear file names ---------------- }

  procedure clearname;
  var i : integer;
  begin
       for i := 0 to 50 do
            field^[1,i] := '';
       top[1] := 0;
       offset[1] := 0;
       num[1] := -1;
  end;

  { -- Clear directory names ------------ }

  procedure cleardirect;
  var i : integer;
  begin
       for i := 0 to 50 do
            field^[2,i] := '';
       top[2] := 0;
       offset[2] := 0;
       num[2] := -1;
  end;

  { -- Clear both file and directory names -- }

  procedure clearfields;
  var i : integer;
  begin
       clearname;
       cleardirect;
       fields := 0;
  end;

  { -- Show the Page -------------------- }

  procedure showpage;
  var i : integer;
  begin
       for i := 0 to 10 do
       begin
            showstring(field^[1,top[1]+i],8,12+i,29,off);
            showstring(field^[2,top[2]+i],43,12+i,29,off);
       end;
       case fields of
            0 :  showstring(filename,7,7,68,ON);
            1 :  showstring(field^[1,top[1]+offset[1]],8,12+offset[1],29,ON);
            2 :  showstring(field^[2,top[2]+offset[2]],43,12+offset[2],29,ON);
       end;
       if fields <> 0 then
            showstring(filename,7,7,68,Off);
  end;

  { --- Fill fields with file and directory names --- }

  procedure fill_it(i:integer;st:string);
  begin
       if i=1 then findfirst(st,Archive,temp)
       else findfirst(st,Directory,temp);

       while (DosError = 0) and (num[i] < 50) do
       if temp.name <> '.' then
       begin
            if (i=1) or (temp.Attr = Directory) then
            begin
                 num[i] := num[i] + 1;
                 field^[i,num[i]] := temp.name;
            end;
            findnext(temp);
       end
       else
            findnext(temp);
  end;

  { --- begin get_file_name ----------------- }

  var i,j,ii : integer;
      buffy : string[1];
  begin

       new(field);
       clearfields;
       ClearScreen;
       textbox(1,1,25,79);
       LineType := double;

       textbox(2,40-7,4,40+7);
       showstring('Select File',40-5,3,12,off);

       textbox(6,5,8,75);

       textbox(9,6,23,38); textbox(9,42,23,74);
       LineType := single;
       TextLineH(11,6,38); TextLineH(11,42,74);
       showstring('File Name',16,10,10,off);
       showstring('Change Directory',50,10,17,off);
       showstring('  Use PgUp / PgDn to Move       Press     when done',10,24,50,off);
       showstring('F10',48,24,3,on);

       clearfields;

       chdir(director);
       fill_it(1,filename);
       fill_it(2,'*.');

       code := 1;
       needs_paint := TRUE;
       fields := 0;

       while TRUE do
       begin
            if needs_paint then
               showpage;
            needs_paint := FALSE;
            getchar;
            dj := 0;
            df := 0;
            if (Code > 32) and (Ch in ['0'..'9','-','+','A'..'Z','a'..'z',' ','_','*','?']) then
            begin
                    GetString(buf,7,7,68,['0'..'9','+','-','.','_','A'..'Z','a'..'z','*','?',':','\','/']);
                    filename := buf;
                    fields := 0;
            end;

            case Code of

                 -68,13: begin
                              case fields of
                                   0 : begin
                                            i := pos('?',filename);
                                            j := pos('*',filename);
                                            ii := pos('.',filename);
                                            if (i=0) and (j=0) and (ii=0) then
                                               if ( switch = Out_Print) then
                                                  filename := filename + '.prn'
                                               else
                                                   filename := filename + '.st3';
                                            findfirst(filename,Directory,temp);
                                            if( switch = Out_Put) or ( switch = Out_Print) then
                                            begin
                                                 findfirst(filename,Archive,temp);
                                                 if (DosError = 0) and (j=0) and (i=0) then
                                                 begin
                                                      showstring('Okay to Rewrite '+filename+' (y,n) ?',7,7,68,Off);
                                                      getchar;
                                                      buffy := ch;
                                                      showstring(buffy,45,7,1,ON);
                                                      if (ch = 'Y') or (ch = 'y') then
                                                      begin
                                                           get_file_name := filename;
                                                           dispose(field);
                                                           getdir(0,in_directory);
                                                           exit;
                                                      end;
                                                      showstring(filename,7,7,68,Off);
                                                 end
                                                 else
                                                 begin
                                                      if (i <> 0) or (j <> 0) then
                                                      begin
                                                           clearfields;
                                                           fill_it(1,filename);
                                                           fill_it(2,'*.');
                                                           needs_paint := true;
                                                      end
                                                      else
                                                      begin
                                                           assign(pout,filename);
                                                           rewrite(pout);
                                                           close(pout);
                                                           get_file_name := filename;
                                                           dispose(field);
                                                           getdir(0,in_directory);
                                                           exit;
                                                      end;
                                                 end;
                                            end { end switch = out_put }
                                            else
                                            begin
                                                 if (i <> 0) or (j <> 0) then
                                                 begin
                                                      findfirst(filename,Archive,temp);
                                                      if (DosError = 0) then
                                                      begin
                                                           fsplit(filename,d,n,e);
                                                           if d <> ''  then
                                                           begin
                                                                in_directory := copy(d,1,length(d)-1);
                                                                chdir(in_directory);
                                                                findfirst(n+e,ARCHIVE,temp);
                                                                if DosError = 0 then
                                                                   filename := n +e
                                                                else
                                                                begin
                                                                     in_directory := filename;
                                                                     filename := '*.';
                                                                     chdir(in_directory);
                                                                end;
                                                           end;
                                                      end;  { end found first }
                                                      clearfields;
                                                      fill_it(1,filename);
                                                      fill_it(2,'*.');
                                                      needs_paint := TRUE;
                                                 end { end are wildcards }
                                                 else
                                                 begin
                                                      if DosError = 0 then
                                                      begin
                                                           findfirst(filename,Archive,temp);
                                                           if DosError = 0 then
                                                           begin
                                                                fsplit(filename,d,n,e);
                                                                if d <> ''  then
                                                                begin
                                                                     in_directory := copy(d,1,length(d)-1);
                                                                     chdir(in_directory);
                                                                     filename := n + e;
                                                                end;
                                                                get_file_name := filename;
                                                                dispose(field);
                                                                getdir(0,in_directory);
                                                                exit;
                                                           end
                                                           else
                                                           begin
                                                                in_directory := filename;
                                                                chdir(in_directory);
                                                                clearfields;
                                                                filename := '*.st3';
                                                                fill_it(1,filename);
                                                                fill_it(2,'*.');
                                                                needs_paint := true;
                                                           end
                                                      end
                                                      else
                                                      begin
                                                           showstring('Okay to Create File '+filename+' (Y,N)',7,7,68,Off);
                                                           getchar;
                                                           buffy := ch;
                                                           showstring(buffy,45,7,1,ON);
                                                           if (ch = 'Y') or (ch = 'y') then
                                                           begin
                                                                filename := '&' + filename;
                                                                get_file_name := filename;
                                                                dispose(field);
                                                                getdir(0,in_directory);
                                                                exit;
                                                           end;
                                                      end;
                                                 end; { end no wild cards }
                                            end; { switch = in_put }
                                       end;  { end fields = 0 }

                                   1 : begin
                                            get_file_name := field^[1,top[1]+offset[1]];
                                            dispose(field);
                                            getdir(0,in_directory);
                                            exit;
                                       end;  { end fields = 1 }

                                   2 : begin
                                            in_directory := field^[2,top[2]+offset[2]];
                                            chdir(in_directory);
                                            if in_directory = '..' then
                                               getdir(0,in_directory);
                                            clearfields;
                                            filename := '*.st3';
                                            fill_it(1,filename);
                                            fill_it(2,'*.');
                                            needs_paint := TRUE;
                                       end;  { end fields = 2}

                              end; { end field case }

                         end;  { end f10 or return code }
                  27 : begin
                            get_file_name := '';
                            dispose(field);
                            getdir(0,in_directory);
                            exit;
                       end;

                 -73 : df :=  -1;
                9,-81: df := +1;

                 -72,-75: DJ := -1;
                 -77,-80: DJ := 1;
            end;  { end case }

            if df <> 0 then
            begin
                 if fields = 0 then
                    showstring(filename,7,7,68,Off)
                 else
                     showstring( field^[fields,top[fields] + offset[fields]],
                                 8 + (fields-1)*35,offset[fields]+12,29,off);

                 fields := fields + df;

                 if fields >= 3 then fields := 0;
                 if fields <= -1 then fields := 2;

                 if fields <> 0 then
                    if num[fields] < 0 then fields := fields + df;

                 if fields >= 3 then fields := 0;
                 if fields <= -1 then fields := 2;

                 if fields = 1 then
                 begin
                      filename := field^[1,top[fields]+offset[fields]];
                      showstring(filename,7,7,68,Off);
                 end;

                 if fields <> 0 then
                 begin
                      offset[fields] := 0;
                      top[fields] := 0;
                      needs_paint := TRUE;
                 end;
                 if fields = 0 then
                    showstring(filename,7,7,68,On)
            end;

            if( dj <> 0) and (fields <> 0) then
            begin
                 i := dj + offset[fields];
                 if (i >= 0) and (i <= 10) and (i+top[fields]<=num[fields]) then
                 begin
                      showstring( field^[fields,top[fields] + offset[fields]],
                                  8 + (fields-1)*35,offset[fields]+12,29,off);
                      offset[fields] := i;
                      showstring( field^[fields,top[fields] + offset[fields]],
                                  8 + (fields-1)*35,offset[fields]+12,29,ON);
                 end
                 else
                 begin
                       i := i + top[fields];
                       if (i >= 0) and (i <= num[fields]) then
                       begin
                             if dj > 0 then top[fields] := top[fields] + 11
                             else top[fields] := top[fields] - 11;
                             if top[fields] + 10  > num[fields] then
                                top[fields] := num[fields] - 10;
                             if top[fields] < 0 then top[fields] := 0;
                             offset[fields] := i - top[fields];
                             needs_paint := TRUE;
                       end;
                 end;

                 if fields = 1 then
                 begin
                      filename := field^[1,top[fields]+offset[fields]];
                      showstring(filename,7,7,68,Off);
                 end;


            end;  { end if j <> 0 .. }

       end; { end while }

       dispose(field);
  end;   { end get_file_name }

{ -------------------------------------------------------------------------- }
{ -- Get_outfile_name returns the outfile associated with the given infile - }
{ -------------------------------------------------------------------------- }

  function get_outfile_name(infile :textstr) : textstr;
  var i : integer;
  begin
          { --- create file to dump output --- }
       if infile = '' then
            get_outfile_name := 'SmpTx3.Out'
       else
       begin
            i := pos('.',infile);
            If i <> 0 then
               get_outfile_name := copy(infile,1,i) + 'out'
            else get_outfile_name := infile + '.out';
       end;
  end;

{ -------------------------------------------------------------------------- }
{ -- Save_data saves the input values to a file ---------------------------- }
{ -------------------------------------------------------------------------- }

  procedure Save_data( filename : textstr);
  var i,j : integer;
      out : text;
  begin
       if length(filename) <= 0 then exit;
       message('Writing data to file:',filename,TRUE);
       assign(out,filename);
       rewrite(out);
       for i := 0 to Max_Reaches do
       begin
            for j := 1 to 2 do
            begin
                 writeln(out,ct[j,i]);
                 writeln(out,cd[j,i]);
                 writeln(out,cp[j,i]);
                 writeln(out);
                 writeln(out,m[j,i]);
                 writeln(out,fd[j,i]);
                 writeln(out,fp[j,i]);
                 writeln(out,pc[j,i]);
                 writeln(out,h [j,i]);
                 writeln(out,kd[j,i]);
                 writeln(out,kp[j,i]);
                 writeln(out,k [j,i]);
                 writeln(out,dt[j,i]);
            end;
            writeln(out,ws[i]);
            writeln(out,wrs[i]);
            writeln(out,wd[i]);
            writeln(out,ks[i]);
            writeln(out,a[i]);
            writeln(out,q[i]);
            writeln(out,u[i]);
            writeln(out,wt[i]);
            writeln(out,kl[i]);
            writeln(out,ad[i]);
            writeln(out,vl[i]);
            writeln(out,discharge_number[i]);
            writeln(out,r_length[i]);
            writeln(out,Facility_Name[i]);
       end;
       writeln(out,Stream_Name);
       writeln(out,Upstream_River_mile);
       writeln(out,Number_discharges);
       writeln(out,Number_reaches);
       writeln(out,Pollutant_name);
       writeln(out,Pollutant_units);
       writeln(out,scaling_factor);
       writeln(out,Display_title);
       writeln(out,last_buf);
       writeln(out,total_buf);
       writeln(out,Printer_name);
       writeln(out,Printer_res);

       if need_disk then
          writeln(out,'TRUE')
       else writeln(out,'FALSE');

       for i :=1 to Max_reaches do
           for j:=1 to 15 do
           begin
               if j<=5 then
                  writeln(out,effluent_com[i,j]);
               writeln(out,reach_com[i,j]);
           end;
       for i:=1 to 5 do
           writeln(out,upstream_com[i]);

       for j := 1 to Max_observations do
           for i := 0 to 7 do
               writeln(out,observations[i,j]);

       writeln(out,model_type);
       close(out);

  end;   { save_data }

{ -------------------------------------------------------------------------- }
{ -- LOAD_DATA loads input values from a file ------------------------------ }
{ -------------------------------------------------------------------------- }

  procedure Load_Data( filename : textstr);
  var i,j,ii : integer;
      inn : text;
      out : text;
      buf : string[255];
  begin
       if length(filename) <= 0 then exit;
       if not first_time_f then
          message('Reading data from file:',filename,TRUE)
       else
           message('','Reading data from file: '+filename,FALSE);
       assign(inn,filename);
       reset(inn);
       for i := 0 to Max_Reaches do
       begin
            for j := 1 to 2 do
            begin
                 readln(inn,ct[j,i]);
                 readln(inn,cd[j,i]);
                 readln(inn,cp[j,i]);
                 readln(inn);
                 readln(inn,m[j,i]);
                 readln(inn,fd[j,i]);
                 readln(inn,fp[j,i]);
                 readln(inn,pc[j,i]);
                 readln(inn,h [j,i]);
                 readln(inn,kd[j,i]);
                 readln(inn,kp[j,i]);
                 readln(inn,k[j,i]);
                 readln(inn,dt[j,i]);
            end;
            readln(inn,ws[i]);
            readln(inn,wrs[i]);
            readln(inn,wd[i]);
            readln(inn,ks[i]);
            readln(inn,a[i]);
            readln(inn,q[i]);
            readln(inn,u[i]);
            readln(inn,wt[i]);
            readln(inn,kl[i]);
            readln(inn,ad[i]);
            readln(inn,vl[i]);
            readln(inn,discharge_number[i]);
            readln(inn,r_length[i]);
            readln(inn,Facility_Name[i]);
       end;
       readln(inn,Stream_Name);
       readln(inn,Upstream_River_mile);
       readln(inn,Number_discharges);
       readln(inn,Number_reaches);
       readln(inn,Pollutant_name);
       readln(inn,Pollutant_units);
       readln(inn,scaling_factor);
       readln(inn,Display_title);
       readln(inn,last_buf);
       readln(inn,total_buf);
       readln(inn,Printer_name);
       readln(inn,Printer_res);

(*       { --- Poke the Printer so that print screens look okay --- }
       if Printer_name = 'HEWLETT PACKARD LASERJET' then
       begin
            rewrite(lst);
            write(lst,$1B,',');
            write(lst,$28,',');
            write(lst,$31,',');
            write(lst,$30,',');
            writeln(lst,$55);
       end; *)

       readln(inn,buf);
       if buf = 'TRUE' then need_disk := TRUE
       else need_disk := FALSE;

       for i :=1 to Max_reaches do
           for j:=1 to 15 do
           begin
               if j<=5 then
                  readln(inn,effluent_com[i,j]);
               readln(inn,reach_com[i,j]);
           end;
       for i:=1 to 5 do
           readln(inn,upstream_com[i]);

       for j := 1 to Max_observations do
           for i := 0 to 7 do
               readln(inn,observations[i,j]);

       readln(inn,model_type);
       close(inn);

  end;   {  end save_data }


{ -------------------------------------------------------------------------- }
{ -- PRINT_DATA prints input and out to a file or to the printer ----------- }
{ -- This procedure is makes the assumption that graph_buf[1] contains all - }
{ -- the relevant output. -------------------------------------------------- }
{ -------------------------------------------------------------------------- }

  procedure print_data;
  var i,j,k     : integer;
      out       : Text;
      outd,outn : Textstr;
      buf       : textstr;
      lines     : integer;
      nextmark  : real;
      lastmark  : real;
      per_mark  : real;

  procedure dump(x : real; i : integer);
  var temp      : sfields;
  begin
       set_point(x,temp);
       write(out,temp:i);
  end;

  procedure dumpln(x : real; i : integer);
  var temp      : sfields;
  begin
       set_point(x,temp);
       writeln(out,temp:i);
  end;

  procedure check(var ln : integer;inc : integer);
  begin
       if ln + inc > 60 then
       begin
            write(out,#12);
            writeln(out); writeln(out);
            ln := 2;
       end;
  end;

  procedure head_observed;
  begin
       check(lines,4);
       writeln(out);
       writeln(out,'  River   Dissolved    Dissolved     Total       Total        Suspended');
       writeln(out,'  Mile    Water Conc   Bed Conc      Water Conc  Bed Conc      Solids');
       writeln(out);
       lines := lines +4;
  end;

  procedure head_data;
  begin
       check(lines,5);
       writeln(out);
       writeln(out,'                 '+Pollutant_name + '  ('+pollutant_units+')');
       writeln(out,'River    Total    Total Dissolved  Dissolved  Particulate  Particulate  Suspended');
       writeln(out,'Mile     Water    Bed   Water      Bed        Water        Bed          Solids');
       writeln(out);
       lines := lines + 5;
  end;

  begin

       i := 1;
       GetMenuChoice(i,'Write to Printer or to File/Printer//File');
       if i = ESCAPE then
          exit;
       if i = 1 then
          assign(out,'PRN')
       else
       begin
            outd := in_directory;
            outn := '*.prn';
            if get_file_name(outd,outn,Out_Print) = '' then
                exit;
            assign(out,outn);
            rewrite(out);
            writeln(out,'"OUTPUT RESULTS:"');
            writeln(out,'"'+Pollutant_name + '  ('+pollutant_units+')"');
            writeln(out,'"River","Total","Total","Dissolved","Dissolved","Particulate","Particulate","Suspended"');
            writeln(out,'"Mile","Water","Bed","Water","Bed","Water","Bed","Solids"');
            i := 0;
            while i<last_buf do
            begin
                 dump(graph_buf[1]^[0,i],12);
                 dump(graph_buf[1]^[1,i],12);
                 dump(graph_buf[1]^[2,i],12);
                 dump(graph_buf[1]^[3,i],12);
                 dump(graph_buf[1]^[4,i],12);
                 dump(graph_buf[1]^[5,i],12);
                 dump(graph_buf[1]^[6,i],12);
                 dumpln(graph_buf[1]^[7,i],12);
                 i := i +1;
            end;

            close(out);
            exit;
       end;

       message('Writing Output to Printer','This may take a few minutes',TRUE);
       rewrite(out);

       writeln(out,'FILENAME: '+infile_name);
       writeln(out);
       writeln(out);
       writeln(out,'RUN INFORMATION:');
       writeln(out,'   ', 'Name of receiving stream:      ', stream_name:25);
       write(out,'   '+ 'River mile upstream boundary:  ');
       dumpln(upstream_river_mile,25);

       write(out,'   '+ 'Number of discharges:          ');
       dumpln(number_discharges,25);

       write(out,'   '+ 'Number of reaches:             ');
       dumpln(number_reaches,25);

       writeln(out,'   ', 'Name of pollutant:             ',pollutant_name:25);

       writeln(out,'   ', 'Pollutant concentration units: ' , pollutant_units:25);

       writeln(out,'   ', 'Run title for screen display   ' , Display_title:25);

       writeln(out);
       writeln(out);
       writeln(out,'UPSTREAM RIVER PARAMETERS:');
       write(out,'   '+ 'Flow                        (cfs): ');
       dumpln(q[0],25);

       buf := copy('                             ',1,25-length(Pollutant_name)-length(Pollutant_units));
       write(out,'   '+ 'Total '+Pollutant_name + buf + '('+Pollutant_units+'): ');
       dumpln(ct[1,0],25);

       write(out,'   '+ 'Suspended Solids Conc.     (mg/L): ');
       dumpln(m[1,0],25);

       write(out,'   '+ 'Bed Solids Concentration   (mg/L): ');
       dumpln(m[2,0],25);

       writeln(out);
       writeln(out);
       { 21 lines so far }
       writeln(out,'EFFLUENT PARAMETERS:');
       lines := 21;
       for i := 1 to number_discharges do
       begin
            check(lines,7);
            writeln(out);
            str(i,buf);
            writeln(out,'  Discharge '+buf);
            writeln(out,'    ','Name of Discharger:             ' , facility_name[discharge_number[i]]:25);
            writeln(out,'    ' ,'Beginning of Reach Number:      ', discharge_number[i]:25);

            write(out,'    ' +'Flow                     (MGD): ');
            dumpln(q[discharge_number[i]],25);

            buf := copy('                             ',1,22-length(Pollutant_units)-length(Pollutant_name));
            write(out,'    ' +'Total ' + Pollutant_name + buf + '('+Pollutant_units+'): ');
            dumpln(dt[1,discharge_number[i]],25);

            write(out,'    ' +'Suspended Solids Conc.  (mg/L): ');
            dumpln(m[1,discharge_number[i]],25);

            lines := lines + 7;
       end;

       check(lines,3);
       writeln(out);
       writeln(out);
       writeln(out,'REACH PARAMETERS:');
       lines := lines + 3;
       for i := 1 to number_reaches do
       begin
            check(lines,17);
            writeln(out);
            str(i,buf);
            writeln(out,'  Reach '+buf);

            write(out,'    ' + 'Length                             (mile): ');
            dumpln(r_length[i],25);

            write(out,'    ' + 'Average Depth                      (feet): ');
            dumpln(h[1,i],25);

            write(out,'    ' + 'Velocity                            (fps): ');
            dumpln(u[i],25);

            write(out,'    ' + 'Water Col. Particulate Decay rate (1/day): ');
            dumpln(kp[1,i],25);

            write(out,'    ' + 'Water Col. Dissolved Decay rate   (1/day): ');
            dumpln(kd[1,i],25);

            write(out,'    ' + 'Volatilization                    (1/day): ');
            dumpln(vl[i],25);

            write(out,'    ' + 'Bed Particulate Decay Rate        (1/day): ');
            dumpln(kp[2,i],25);

            write(out,'    ' + 'Bed Dissolved Decay Rate          (1/day): ');
            dumpln(kd[2,i],25);

            write(out,'    ' + 'Sus. Solids Settling Velocity     (m/day): ');
            dumpln(ws[i],25);

            write(out,'    ' + 'Sus. Solids Resuspension Velocity (m/day): ');
            dumpln(wrs[i],25);

            write(out,'    ' + 'Water Col. Partition Coefficient   (L/mg): ');
            dumpln(pc[1,i],25);

            write(out,'    ' + 'Bed Partition Coefficient          (L/mg): ');
            dumpln(pc[2,i],25);

            write(out,'    ' + 'Active Bed Depth                   (feet): ');
            dumpln(h[2,i],25);

            write(out,'    ' + 'Diffusive Exchange Coefficient    (m/day): ');
            dumpln(kl[i],25);

            write(out,'    ' + 'Atmospheric Deposition       (g/mile/day): ');
            dumpln(ad[i],25);
            lines := lines + 17;
       end;

       check(lines,4);
       writeln(out);
       writeln(out);
       writeln(out,'OBSERVED DATA:');
       writeln(out);
       lines := lines + 4;
       i := 1;
       head_observed;
       while (i<=max_observations) and (observations[0,i] <> 0) do
       begin
            j := lines;
            check(lines,1);
            if j > lines then head_observed;
            dump(observations[0,i],7);
            dump(observations[3,i],10);
            dump(observations[4,i],13);
            dump(observations[1,i],13);
            dump(observations[2,i],14);
            dumpln(observations[7,i],12);
            lines := lines + 1;
            i := i + 1;
       end;


       lines := 1000;    { much bigger than 1 page }
       check(lines,3);
       writeln(out);
       writeln(out);
       writeln(out,'OUTPUT RESULTS:');
       lines := lines + 3;
       head_data;
       i := 0;
       j := 0;
       nextmark := Upstream_river_mile;
       lastmark := Upstream_river_mile;
       per_mark := last_buf /( 54 - (2 * number_reaches));
       if per_mark < 0 then per_mark := last_buf;
       k := 1;
       while i<last_buf do
       begin
            if (abs(nextmark - graph_buf[1]^[0,i]) < 0.0001) or ( j >= per_mark) then
            begin
                 if abs(nextmark - graph_buf[1]^[0,i]) < 0.0001 then
                    if nextmark = lastmark then
                    begin
                         nextmark := nextmark - r_length[k];
                         k := k + 1;
                    end
                    else
                        lastmark := nextmark
                 else
                      j := 0;

                 dump(graph_buf[1]^[0,i],6);
                 dump(graph_buf[1]^[1,i],9);
                 dump(graph_buf[1]^[2,i],9);
                 dump(graph_buf[1]^[3,i],10);
                 dump(graph_buf[1]^[4,i],10);
                 dump(graph_buf[1]^[5,i],12);
                 dump(graph_buf[1]^[6,i],12);
                 dumpln(graph_buf[1]^[7,i],10);
            end;
            i := i + 1;
            j := j + 1;
            lines := lines + 1;
       end;
       write(out,#12);
       close(out);

  end; { end print_data }

end.   { end implementation }
