{ -------------------------------------------------------------------------- }
{ -- STX3_FUN contains a few commonly used mathematical functions.  This --- }
{ -- module is called by stx3_grp and was modified from the version that --- }
{ -- appears in PEN. ------------------------------------------------------- }
{ -------------------------------------------------------------------------- }


{ ----------------------- Created  6/5/90 by DC ---------------------------- }
{ ------------------------- Modification lists ----------------------------- }

{ this file has never been modified }

{ -------------------------------------------------------------------------- }
{ -------------------------------------------------------------------------- }
unit stx3_fun;

interface

const

ln10 = 2.30258509299405;


function power(a,b:real):real;
function _10to(b:real):real;
function Log10(x: real): real;

{ ======================================================== }

implementation


function power(a,b:real):real;
begin

  if a=0
     then power:=0
     else power:= exp(b*ln(a));

  end;

function _10to(b:real):real;
begin

  _10to := exp(b*ln10);
  end;

function Log10(x: real): real;
begin

  Log10 := Ln(x)/Ln10;
  end;

end.   { end implementation }
