{ -------------------------------------------------------------------------- }
{ -- STX3_GRP contains routines used for graphing results of SMPTOX3.  ----- }
{ -- These routines are somewhat general and have been adapted from -------- }
{ -- the graphics used on PEN. --------------------------------------------- }
{ -------------------------------------------------------------------------- }


{ ----------------------- Created  6/5/90 by DC ---------------------------- }
{ ------------------------- Modification lists ----------------------------- }

{ 6/6/90   Changed Soil to Sediment at DWD request - DC }
{ 6/10/90  Inabled single toxicant viewing, scaling by miles - DC }
{ 6/13/90  Adding Sensitivity analysis and observational data - DC }
{ 7/2/90   Back from vacation, returning to observational data - DC }
{ 7/9/90   Putting in graph of standard - DC }
{ 7/10/90  Adding Analytical Solution - DC }
{ 7/12/90  Changing Graphics Buffer to allow for 5 graphs at same time - DC }
{ 8/1/90   Making lots of changes at request of client - DC }
{ 8/8/90   Changing line thickness etc. to look better on CGA - DC }
{ 8/13/90  Redoing memory managerment - DC }
{ 10/7/90  Changing Function number order - DC }
{ 1/5/91   Adding SMPTOX123 abilities - DC }
{ 2/12/92  Conditional compile for printer support - TS}

{ -------------------------------------------------------------------------- }
{ -------------------------------------------------------------------------- }

unit stx3_grp;

{ DEFINE USE_PRINTER} { Compile with printer support }
{$UNDEF  USE_PRINTER} { Compile without printer support }
{
         Set the conditional define symbol USE_PRINTER in STX3_GRP.PAS
         and re-compile to create a version of the program with printer
         graphics included. You will need the following additional
         GRAF/DRIVE PLUS 2.0 files, available from Fleming Software
         (703.591.6451):

            GRAPHADD.TPU
            $LQ.OBJ \
            $FX.OBJ ------> Created using BGI2OBJ from $*.BGI files.
            $LJ.OBJ /
}

interface

uses
 textutil,
 scrnutil,
 stx3_var,
 stx3_msc,
 stx3_fun,
 stx3_fil,

 graph,

{$IFDEF USE_PRINTER}

 lq,
 fx,
 lj,
 graphAdd,

{$ENDIF}

 crt;

procedure Show_Graph(graph_type : integer);

{ -------------------------------------------------------------------------- }
{ -------------------------------------------------------------------------- }
var
max_plots : integer;
nplots     : integer;

implementation

var

Hide_Prompt : Boolean;
hide_title :textstr;
ScrXmin: integer;
ScrYmin: integer;
ScrXmax: integer;
ScrYmax: integer;

AbsMaxX: real;
AbsMaxY: real;
LineWidth: real;

YtickL : integer;
Yticks : integer;
XtickL : integer;
Xticks : integer;
Xsig   : integer;
Ysig   : integer;

BackC  : integer;
GraphC : integer;
oldC   : integer;
db_color : array[1..8] of integer;
sa_color : array[1..max_graphs] of integer;
LineC  : integer;
TextC  : integer;
TextW,TextH : integer;

distance : array[0..Max_reaches+1] of real;
mark_reach : boolean;
draw_grid : boolean;
oldcode    : integer;
which_graph : integer;
two_plots   : boolean;

GraphDriver: integer;
GraphMode  : integer;
ErrorCode  : integer;

procedure GetStringG(var Input: textstr; X,Y,L: integer; CharSet: ASCII);

var

Blen: integer;
lin: integer;
i :integer;

procedure Erase;
begin

  Input := '';
  Blen := 0;
  SetFillStyle(SolidFill,GraphC);
  Bar(X,Y-2,X+TextW*L,(Y-2)+TextH);

  end;

begin
  TextW := 8;
  TextH := 10;
  lin := 0;
  TextColor(textC);
  TextBackground(BackC);
  Erase;
  moveto(X,(Y-3)+TextH);
  lineto(X+TextW,(Y-3)+TextH);
  getchar;
  while (Code > 31) or (Code = 8) or (Code = -83) do
  begin

    SetColor(TextC);

    case Code of

       -83: Erase;
         8: if BLen > 0 then
            begin
               Bar(X+TextW*(Blen-1),(Y-2),X+TextW*L,(Y-2)+TextH);
               moveto(X+TextW*(Blen-1),(Y-3)+TextH);
               lineto(X+TextW*(Blen),(Y-3)+TextH);
               if Blen > 1 then Input := Copy (Input,1,Blen-1)
               else Input := '';
            end;
       else
           if (Ch in CharSet) and (BLen < L)  then
           begin
                Input := Input + Ch;
                Bar(X+TextW*(Blen),(Y-2),X+TextW*(L+1),(Y-2)+TextH);
                outTextxy(X+TextW*Blen,Y,ch);
                moveto(X+TextW*(Blen+1),(Y-3)+TextH);
                lineto(X+TextW*(Blen+2),(Y-3)+TextH);
            end;

    end; { end case }

    BLen := Length(Input);
    SetColor(textc);

    GetChar;
    end;

  end;

function Sig(X:real; N: integer): real;
begin

  if X = 0
     then Sig := 0
     else Sig := Trunc(0.5 + X * Exp(ln10*N)) / Exp(ln10*N);

  end;

procedure GraphScreenDefaults(Driver :integer);
var i : integer;
begin

  AbsMaxX := getmaxx;
  AbsMaxY := getmaxy;
  ScrXmin :=  trunc(AbsMaxX * 0.14);
  ScrXmax :=  trunc(AbsMaxX * 0.92);
  ScrYMax := trunc(AbsMaxY * 0.12);
  ScrYMin := trunc(AbsMaxY * 0.78);
  linewidth := 0.03;
  YtickL  :=   5;

  if (Driver = CGA) or (Driver = MCGA) then
  begin
       YtickL  :=   3;
       ScrYMax := trunc(AbsMaxY * 0.15);
       ScrYMin := trunc(AbsMaxY * 0.68);
       linewidth := 0.045;
  end;

  Xticks := 5; XSig := 2;
  Yticks := 5; YSig := 2;
  XtickL := 3;

  if GetMaxColor > 14 then
  begin
       BackC  := 11;
       GraphC := 15;
       db_color[1] := 4;
       db_color[3] := 14;
       db_color[5] := 1;
       db_color[2] := 4;
       db_color[4] := 14;
       db_color[6] := 1;
       db_color[7] := 4;
       db_color[8] := 1;

       sa_color[1] := 4;
       sa_color[2] := 1;
       sa_color[3] := 2;
       sa_color[4] := 7;
       sa_color[5] := 14;
       sa_color[6] := 5;
       sa_color[7] := 8;
       sa_color[8] := 4;
       sa_color[9] := 1;
       sa_color[10] := 2;
       sa_color[11] := 7;

       LineC  :=  0;
       TextC  :=  0;
       end

  else
  begin
       BackC  :=  0;
       GraphC :=  0;
       for i := 1 to 8 do
       begin
            db_color[i] := 1;
            sa_color[i] := 1;
       end;
       sa_color[9] := 1;
       sa_color[10] := 1;
       sa_color[11] := 1;

       LineC  :=  1;
       TextC  :=  1;
   end;
end;

{-----------------------------------------}


Procedure Draw_Axes(Title,Xlabel,Ylabel:TextStr;
                   TXmin,TYmin,TXmax,TYmax: real);
var

NX, NY, I, Xp, Yp, Xc,lenn: integer;
X,Y:  real;
Buf: TextStr;
Xmin,Xmax,Ymin,Ymax,TextW,TextH : real;

begin

  Xmin := TXmin; Ymin := TYmin;
  Xmax := TXmax; Ymax := TYmax;

  SetFillStyle(SolidFill, GraphC); Bar(ScrXMin, ScrYMin, SCrXMax, ScrYmax);
  SetColor(LineC);
  Rectangle(ScrXMin, ScrYMin, SCrXMax, ScrYmax);

  TextColor(TextC);
  TextBackground(BackC);


  { ----- X axis ticks ----- }

    Xc := (ScrXmin + ScrXmax) div 2;

  settextjustify(LeftText,toptext);
  if Xmin <> Xmax
     then begin

       NX := Xsig - Trunc(Ln(Abs(Xmin - Xmax))/Ln10);

       for I := 0 to Xticks do
       begin

         { ----- Draw tick marks ----- }

         Xp := Trunc(ScrXmin + I/Xticks*(ScrXmax - ScrXmin));
         MoveTo(Xp,ScrYmin); LineTo(Xp,ScrYmin-XTickL);

         { ----- Put on number ----- }

         X := Sig(Xmin + I/Xticks * (Xmax - Xmin),NX);

         if NX > 0
            then begin

              Str(X:1:NX,Buf);
              TextW := TextWidth(Buf);
              OutTextXY(trunc(Xp-TextW+2),ScrYmin+4,Buf)
              end

            else begin

              Str(X:1:0,Buf);
              OutTextXY(Xp,ScrYmin+4,Buf)
              end;

         end {Do I};

       end {X-axis ticks};

  { ----- Y axis ticks ----- }

  if Ymin <> Ymax
     then begin

       NY := YSig - Trunc(Ln(Abs(Ymin - Ymax))/Ln10);

       for I := 0 to Yticks do
       begin

         { ----- Draw tick marks ----- }
         if draw_grid then
         begin
              setlinestyle(dottedln,0,normwidth);
              Yp := Trunc(ScrYmin + I/Yticks*(ScrYmax - ScrYmin));
              MoveTo(ScrXmin,Yp); LineTo(ScrXmax,Yp);
              setlinestyle(solidln,0,normwidth);
         end
         else
         begin
              setlinestyle(solidln,0,normwidth);
              Yp := Trunc(ScrYmin + I/Yticks*(ScrYmax - ScrYmin));
              MoveTo(ScrXmin,Yp); LineTo(ScrXmin+YtickL,Yp);
         end;

         { ----- Put on number ----- }

         if (Ymax - Ymin) >= 5 then
         begin
              Y := Sig(Ymin + I/Yticks * (Ymax - Ymin),NY);
              Str(Y:1:0,Buf);
         end
         else
         if (Ymax - Ymin) >= 0.5 then
            Str((Ymin+ I/Yticks * (Ymax - Ymin)):1:1,Buf)
         else
         if (Ymax - Ymin) >= 0.05 then
            Str((Ymin+ I/Yticks * (Ymax - Ymin)):1:2,Buf)
         else
         if (Ymax - Ymin) >= 0.005 then
            Str((Ymin+ I/Yticks * (Ymax - Ymin)):1:3,Buf)
         else
         if (Ymax - Ymin) >= 0.0005 then
            Str((Ymin+ I/Yticks * (Ymax - Ymin)):1:4,Buf)
         else
         if (Ymax - Ymin) >= 0.00005 then
            Str((Ymin+ I/Yticks * (Ymax - Ymin)):1:5,Buf)
         else
            Str((Ymin+ I/Yticks * (Ymax - Ymin)):1:6,Buf);

         TextW := TextWidth(Buf);
         TextH := TextHeight(Buf);
         OutTextXY(trunc(ScrXmin - TextW - 4), trunc(Yp-TextH / 2),Buf)

       end {Y-axis ticks};

       end;

  SetTextJustify(CenterText,TopText);
  OutTextXY(Xc,ScrYmin + trunc(AbsmaxY*(linewidth+0.015)),Xlabel);
  SetTextStyle(DefaultFont,VertDir,1);
  SetTextJustify(CenterText,CenterText);
  OutTextXY(trunc(AbsMaxX * 0.02),(ScrYmin+ScrYmax) div 2,Ylabel);
  lenn := TextWidth(title);
  if textWidth(display_title) > lenn then lenn := textwidth(display_title);
  lenn := lenn div 2;

  SetFillStyle(SolidFill,GraphC); Bar(Xc - trunc(AbsMaxX * 0.02) - Lenn,trunc(AbsMaxY * 0.02),
                                      Xc + trunc(AbsMaxX * 0.02) + Lenn,ScrYmax - trunc(AbsMaxY * 0.02));

  SetColor(LineC); Rectangle(Xc - trunc(AbsMaxX * 0.02) - Lenn,trunc(AbsMaxY * 0.02),
                             Xc + trunc(AbsMaxX * 0.02) + Lenn,ScrYmax - trunc(AbsMaxY * 0.02));

  SetTextStyle(DefaultFont,HorizDir,1);
  SetTextJustify(CenterText,TopText);
  OutTextXY(xc,trunc(absmaxY * 0.03),Title);
  OutTextXY(xc,trunc(absmaxY * (0.03 + linewidth)),Display_Title);



end {DrawAxes};

procedure MakeAxes(title,xaxis,yaxis : TextStr; min_value,max_value : real);

VAR
x_now,DX,i,j  : integer;
y_now    : integer;
DX_Real : real;
total : real;
xp,textw :integer;
X : real;
xmin, xmax : real;
inc   : real;
marks : integer;
buf : Textstr;

begin

     Draw_Axes(title,xaxis,yaxis,0,0,0,max_value);

  xmin  := graph_buf[1]^[0,0];
  xmax  := graph_buf[1]^[0,last_buf-1];
  total := 0;

  for i := 1 to number_reaches do
      total := total + r_length[i];

  distance[1] := 0;
  if mark_reach then
       for i := 2 to number_reaches+1 do
           distance[i] := r_length[i-1]/total + distance[i-1]
  else
  begin
       inc := total / 4;

       if inc > 100 then inc := (trunc(inc/100) + 1) * 100
       else if inc > 50 then inc := 50
       else if inc > 20 then inc := 20
       else if inc > 10 then inc := 10
       else if inc > 5 then inc := 5
       else if inc > 2 then inc := 2
       else if inc > 1 then inc := 1
       else if inc > 0.5 then inc := 0.5
       else if inc > 0.2 then inc := 0.2
       else inc := 0.1;

       if inc > 1 then
          distance[2] := (trunc(upstream_river_mile) mod trunc(inc)) + upstream_river_mile - trunc(upstream_river_mile)
       else distance[2] := ( trunc(upstream_river_mile * 10.0) mod trunc(inc * 10.0)) / 10;

       marks := 2;
       while distance[marks] + inc < total do
       begin
            marks := marks + 1;
            distance[marks] := distance[marks -1] + inc;
       end;

  end;

  settextjustify(centertext,toptext);
  textcolor(textc);

  if mark_reach then
  begin
       setlinestyle(dottedln,0,normwidth);
       for I := 1 to number_reaches do
       begin

            { ----- Draw tick marks ----- }
            if i <> number_reaches then
            begin
               Xp := Trunc(ScrXmin + distance[I+1]*(ScrXmax - ScrXmin));
               MoveTo(Xp,ScrYmin); LineTo(Xp,ScrYmax);
            end;

            { ----- Put on number ----- }

             Xp := Trunc(ScrXmin + (distance[i]+distance[I+1])/2*(ScrXmax - ScrXmin));
             Str(I:0,Buf);
             OutTextXY(Xp,ScrYmin+4,Buf)
       end;
       setlinestyle(solidln,0,normwidth);
  end
  else
       for I := 2 to marks do
       begin

            { ----- Draw tick marks ----- }
            if draw_grid then
            begin
                 setlinestyle(dottedln,0,normwidth);
                 Xp := Trunc(ScrXmin + distance[I]*(ScrXmax - ScrXmin)/total);
                 MoveTo(Xp,ScrYmin); LineTo(Xp,ScrYmax);
                 setlinestyle(solidln,0,normwidth);
            end
            else
            begin
                 setlinestyle(Solidln,0,normwidth);
                 Xp := Trunc(ScrXmin + distance[I]*(ScrXmax - ScrXmin)/total);
                 MoveTo(Xp,ScrYmin); LineTo(Xp,ScrYmin +5);
            end;

            { ----- Put on number ----- }

            Xp := Trunc(ScrXmin + distance[I]*(ScrXmax - ScrXmin)/total);
            if inc >= 1 then
               Str(upstream_river_mile-distance[i]:1:0,Buf)
            else
                Str(upstream_river_mile-distance[i]:2:1,Buf);
             OutTextXY(Xp,ScrYmin+4,Buf);
       end;

  setlinestyle(solidln,0,normwidth);
  end;

{ ======================================================== }
procedure show_graph(graph_type : integer);

VAR

high,low   : real;
i,j,jj     : integer;

ymax      : real;

function MapX(R: real): integer;
begin

   MapX := Trunc(ScrXmin + ( ((R-graph_buf[1]^[0,0])
    / (graph_buf[1]^[0,last_buf-1]-graph_buf[1]^[0,0])) * (ScrXmax - ScrXmin)));
end;

function MapY(Y: real): integer;
begin

  if y < 0
     then mapy := scrymin
     else MapY := Trunc(ScrYMin + (ScrYmax - ScrYmin) * Y/ymax);
  end;


procedure graph_part( which : integer);
var i,ii,xx,yy,dd,cc,j : integer;
    tstring : textstr;
    buf : textstr;
    rect : array[1..4] of pointtype;
    temp_b : boolean;
    t_ymax : real;
    t_place : integer;

procedure show_bottom;
var i : integer;
begin
     if (graph_type = observation_plot) and (which < 8) then
     begin
          setColor(LineC);
          SetFillStyle(SolidFill,LineC);
          cc := trunc(AbsMaxX * 0.011);
          dd := trunc(AbsMaxY * 0.012);
          if (GraphDriver=CGA) or (GraphDriver=MCGA) then
               SetLineStyle(SolidLn,0,normwidth)
          else
               SetLineStyle(SolidLn,0,Thickwidth);

          for i := 1 to max_observations do
              if observations[which,i] <> 0 then
              begin
                   xx := mapx(observations[0,i]);
                   yy := mapy(observations[which,i]);
                   moveto(xx+cc,yy);lineto(xx-cc,yy);
                   moveto(xx,yy+dd);lineto(xx,yy-dd);
              end;
     end;
     TextColor(TextC);
     setcolor(textc);
     TextBackground(BackC);
     settextjustify(LeftText,toptext);

     SetLineStyle(SolidLn,0,normwidth);
     setcolor(lineC);
     Rectangle(ScrXMin, ScrYMin, SCrXMax, ScrYmax);
     if not hide_prompt then
     begin
          if graph_type = Sensitivity_plot then
          begin
               TextColor(sa_color[which_graph-1]);
               setcolor(sa_color[which_graph-1]);
               if nplots <> max_plots then
                  OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 2.1 * linewidth),
                            sense_name[which_graph-2]+ '   Press Tab to Continue')
               else
                  OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 2 * linewidth),
                                                  sense_name[which_graph-2]);
               TextColor(TextC);
               Setcolor(lineC);
          end;
          if high_model = SMPTOX3 then
          begin
               buf := 'Press:  F1 Total Water Toxicant  F2 Dissolved Water  F3 Particulate Water';
               OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 3* linewidth),buf);
               buf := '        F4 Total Bed Toxicant    F5 Dissolved Bed    F6 Particulate Bed';
               OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 4 * linewidth),buf);
               buf := '        F7 Suspended Solids      F8 Toggle Grid      F9 Add Title';
               OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 5 * linewidth),buf);
               buf := '                   * To Print Graph          F10 To Quit';
               OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 6 * linewidth),buf);
          end  { end SMPTOX3 }
          else
          if high_model = SMPTOX2 then
          begin
               buf := 'Press:  F1 Total Water Toxicant  F2 Dissolved Water  F3 Particulate Water';
               OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 4 * linewidth),buf);
               buf := '        F7 Suspended Solids      F8 Toggle Grid      F9 Add Title';
               OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 5 * linewidth),buf);
               buf := '                   * To Print Graph          F10 To Quit';
               OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 6 * linewidth),buf);
          end { end SMPTOX2 }
          else
          begin
               buf := 'Press:                    F1 Total Water Toxicant';
               OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 4 * linewidth),buf);
               buf := '                      F8 Toggle Grid      F9 Add Title';
               OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 5 * linewidth),buf);
               buf := '                      * To Print Graph    F10 To Quit';
               OutTextXY(trunc(absmaxX * 0.05),ScrYmin+trunc(absmaxY * 6 * linewidth),buf);
          end; { end  SMPTOX }
     end { end not hide_prompt }
     else
     begin
          settextjustify(centerText,toptext);
          OutTextXY(trunc(AbsMaxX * 0.5),ScrYmin + trunc(absmaxY * 4 * linewidth),hide_title);
     end;

     which_graph := ii;
end;

var top : integer;
begin { graph_part }
     SetFillStyle(SolidFill,BackC); Bar(0,0,trunc(AbsMaxX),trunc(AbsMaxY));
     SetColor(LineC); Rectangle(1,1,trunc(AbsMaxX-1),trunc(AbsMaxY-1));
     TextColor(TextC);
     TextBackground(BackC);
     settextjustify(LeftText,toptext);
     ymax := 0;

     if( graph_type = WLA_Plot) and (which = 1) then
        for i := 1 to max_standards do
          if standard[0,i] > ymax then ymax := standard[0,i];

     if graph_type = sensitivity_plot then
        top := max_plots
     else top := nplots;

     for i := 0 to last_buf-1 do
     begin
          ii := 1;
          while ii <= top do
          begin
               if ymax < graph_buf[ii]^[which,i] then
                  ymax := graph_buf[ii]^[which,i];
                case graph_type of
                     1,2 : ii := Max_graphs +1;
                     3   : ii := ii +1;
                     4   :  ii := ii + 1;
                end;
          end;
     end;

     if (graph_type = OBSERVATION_PLOT) and (which < 8) then
        for i := 1 to max_observations do
          if ymax < observations[which,i] then
             ymax := observations[which,i];

     ymax := ymax * 1.05;

     t_place := 0;

     while ymax > 100 do
     begin
          t_place := t_place +1;
          ymax := ymax  / 10;
     end;

     if ymax > 50 then ymax := 100
     else if ymax > 20 then ymax := 50
     else if ymax > 10 then ymax := 20
     else if ymax > 5 then ymax := 10
     else if ymax > 1 then ymax := 5
     else if ymax > 0.5 then ymax := 1
     else if ymax > 0.2 then ymax := 0.5
     else if ymax > 0.1 then ymax := 0.2
     else if ymax > 0.05 then ymax := 0.1
     else if ymax > 0.02 then ymax := 0.05
     else if ymax > 0.01 then ymax := 0.02
     else if ymax > 0.005 then ymax := 0.01
     else if ymax > 0.002 then ymax := 0.005
     else if ymax > 0.001 then ymax := 0.002
     else if ymax > 0.0005 then ymax := 0.001
     else if ymax > 0.0002 then ymax := 0.0005
     else if ymax > 0.0001 then ymax := 0.0002
     else if ymax > 0.00005 then ymax := 0.0001
     else if ymax > 0.00002 then ymax := 0.00005
     else if ymax > 0.00001 then ymax := 0.00002
     else if ymax > 0.000005 then ymax := 0.00001
     else if ymax > 0.000002 then ymax := 0.000005
     else if ymax > 0.000001 then ymax := 0.000002
     else ymax := 0.000001;

     while t_place > 0 do
     begin
          ymax := ymax * 10;
          t_place := t_place - 1;
     end;


     if mark_reach then tstring := 'Reach'
     else tstring := 'River Mile';

     case which of
       1 : begin
                MakeAxes('Water profile, Total Toxicant',tstring,Pollutant_name+' '+pollutant_units,0,ymax);
                SetColor(LineC);

                { -- show standard --- }
                if graph_type = WLA_plot then
                for I := 1 to max_standards do
                begin
                     if standard[0,I] <> 0 then
                     begin
                          if (i= 1) then temp_b := TRUE
                          else if standard[0,i-1] = 0 then
                               temp_b := TRUE
                          else temp_b := FALSE;

                          if standard[1,i] > graph_buf[which_graph]^[0,0] then
                             standard[1,i] := graph_buf[which_graph]^[0,0];
                          if standard[2,i] < graph_buf[which_graph]^[0,last_buf-1] then
                             standard[2,i] := graph_buf[which_graph]^[0,last_buf-1];
                          if temp_b then
                             MoveTo(MapX(standard[1,i]),MapY(standard[0,i]))
                          else
                             LineTo(MapX(standard[1,i]),MapY(standard[0,i]));
                          LineTo(MapX(standard[2,i]),MapY(standard[0,i]));
                     end;
                end;

(*                { show analytical solution }
                SetLineStyle(SolidLn,0,Thickwidth);
                SetColor(db_color[8]);
                MoveTo(MapX(graph_buf[which_graph]^[0,0]),MapY(graph_buf[which_graph]^[8,0]));
                for I := 1 to last_buf-1 do
                    LineTo(MapX(graph_buf[which_graph]^[0,i]),MapY(graph_buf[which_graph]^[8,i]));
                SetLineStyle(SolidLn,0,normwidth);
*)

           end;
       2 : MakeAxes('Bed profile, Total Toxicant',tstring,Pollutant_name+' '+pollutant_units,0,ymax);
       3 : MakeAxes('Water profile, Dissolved Toxicant',tstring,Pollutant_name+' '+pollutant_units,0,ymax);
       4 : MakeAxes('Bed profile, Dissolved Toxicant',tstring,Pollutant_name+' '+pollutant_units,0,ymax);
       5 : MakeAxes('Water profile, Particulate Toxicant',tstring,Pollutant_name+' '+pollutant_units,0,ymax);
       6 : if scaling_factor > 2000000000 then
                MakeAxes('Bed profile, Particulate Toxicant',tstring,Pollutant_name+' pg/mg',0,ymax)
           else
                MakeAxes('Bed profile, Particulate Toxicant',tstring,Pollutant_name+' ug/mg',0,ymax);
       7 : if (GraphDriver = CGA) or (GraphDriver = MCGA) then
              MakeAxes('Suspended Solids',tstring,'Susp Solids (mg/L)',0,ymax)
           else
              MakeAxes('Suspended Solids',tstring,'Suspended Solids (mg/L)',0,ymax);
       8 : MakeAxes('Burial Velocity',tstring,'exp(mm/year)',0,ymax);
     end;  { end case }

(*     if (graph_type = Sensitivity_Plot) and (GetMaxColor > 14) then
     begin
          { need to fill between points }
          SetFillStyle(SolidFill, sa_color[4]);
          SetColor(sa_color[4]);
          rect[3].x := mapx(graph_buf[2]^[0,0]);
          rect[3].y := mapy(graph_buf[2]^[which,0]);
          rect[4].x := mapx(graph_buf[3]^[0,0]);
          rect[4].y := mapy(graph_buf[3]^[which,0]);

          i := 0;
          while i <= last_buf-1  do
          begin
               rect[1].x := rect[4].x;
               rect[1].y := rect[4].y;
               rect[2].x := rect[3].x;
               rect[2].y := rect[3].y;
               i := i +1;
               rect[3].x := mapx(graph_buf[3]^[0,i]);
               rect[3].y := mapy(graph_buf[3]^[which,i]);
               rect[4].x := mapx(graph_buf[2]^[0,i]);
               rect[4].y := mapy(graph_buf[2]^[which,i]);
               fillpoly(sizeof(rect) div sizeof(pointtype),rect);
          end;
     end;
  *)

     ii := which_graph;
     while which_graph <= nplots do
     begin
          if (GraphDriver=CGA) or (GraphDriver=MCGA) then
             SetLineStyle(SolidLn,0,normwidth)
          else
             SetLineStyle(SolidLn,0,Thickwidth);

          SetColor(db_color[1]);
          if( graph_type = many_plot) or (graph_type = sensitivity_plot) then
              setColor(sa_color[which_graph]);


          MoveTo(MapX(graph_buf[which_graph]^[0,0]),MapY(graph_buf[which_graph]^[which,0]));
          for I := 1 to last_buf-1 do
               LineTo(MapX(graph_buf[which_graph]^[0,i]),MapY(graph_buf[which_graph]^[which,i]));

          if (two_plots) and (which < 3) then
          begin
               j := which + 2;
               MoveTo(MapX(graph_buf[which_graph]^[0,0]),MapY(graph_buf[which_graph]^[j,0]));
               for I := 1 to last_buf-1 do
                    LineTo(MapX(graph_buf[which_graph]^[0,i]),MapY(graph_buf[which_graph]^[j,i]));
          end;

          SetLineStyle(SolidLn,0,normwidth);
          case graph_type of
               1,2              : which_graph := Max_graphs +1;
               Sensitivity_plot : which_graph := which_graph +1;
               many_plot        :
               begin
                    i := scrxmin + trunc(absmaxX * 0.04);
                    j := mapy(ymax) + trunc(absmaxY * linewidth) * (which_graph-1) + 1;
                    settextjustify(LeftText,toptext);
                    SetFillStyle(SolidFill,sa_color[which_graph]);
                    bar(i-trunc(absmaxX * 0.03),j+1,i-trunc(absmaxX * 0.02),j+trunc(absmaxY * 0.02));
                    outtextxy(i,j+3,files[which_graph]);
                    which_graph := which_graph + 1;
               end;
          end;  { end case }
     end; { end while }
     show_bottom;

end;  { end graph_part }

{$IFDEF USE_PRINTER}

const
    info : DrvINFO = (DrvMem:32000; DrvWrkdrive:'';
        DrvOutfile : ''; escchk : TRUE; nohead : FALSE );

{$ENDIF}

var tempC : integer;
    buf : string[100];
    id,moddd : integer;
    hardCopy : Boolean;

begin { procedure show_graph }

  mark_reach := true;
  hide_prompt := False;
  draw_grid := False;
  hide_title := '';

  which_graph := 1;
  two_plots := FALSE;

  GraphDriver := Detect;
{   GraphDriver := CGA;
   GraphMode := CGAhi; }
  InitGraph(GraphDriver,GraphMode,'');

  if graphDriver < 0 then
  begin
       Error_message('Can Not initialize graphics');
       exit;
  end;
  GraphScreenDefaults(GraphDriver);


  code := -59;
  oldcode := -59;
  oldC := GraphC;
  HardCopy := FALSE;
{  while ( (code <= -59) and (code >= -67) )
        or ( code = 32) or (code = 9) or (code = 42) do }

  while (code <> -68) and (code <> 27) do
  begin

       if (model_type <> SMPTOX3) and (code = 66)
       then code := oldcode;

       if (code <= -59) and (code >= -65) then
       begin
            if high_model = SMPTOX2 then
            begin
                 if (code < -61) and (code > -65) then
                    code := 0;
            end
            else if high_model = SMPTOX1 then
            begin
                 if code < -59 then code := 0;
            end;
       end;
       if HardCopy = TRUE then
       begin

           {$IFDEF USE_PRINTER}

            ClearDevice;
            bCloseGraph;

           {$ENDIF}

            GraphDriver := Detect;
            InitGraph(GraphDriver,GraphMode,'');
            graphScreenDefaults(GraphDriver);
            hide_prompt := FALSE;
            HardCopy := FALSE;
       end;

       if (code = 42) and (Printer_name<> 'NONE') and
          (Printer_res <> 'NONE') then
       begin
            CloseGraph;
            HardCopy := TRUE;
            Hide_Prompt := TRUE;

         {$IFDEF USE_PRINTER}

            if Printer_name = 'EPSON FX, (9 pin)' then
            begin
                 i := InstallUserDriver('$FX',nil);
                 if i < 0 then
                 begin
                      Error_Message('Can not install FX');
                      exit;
                 end;
                 GraphDriver := i;

                 if (RegisterBGIdriver(@FXDriverProc) < 0) then
                 begin
                      Error_message('Can not register FX');
                      exit;
                 end;
            end
            else
            if Printer_name = 'EPSON LQ, (24 pin)' then
            begin
                 i := InstallUserDriver('$LQ',nil);
                 if i < 0 then
                 begin
                      Error_Message('Can not install LQ');
                      exit;
                 end;
                 GraphDriver := i;

                 if (RegisterBGIdriver(@LqDriverProc) < 0) then
                 begin
                      Error_message('Can not register LQ');
                      exit;
                 end;
            end
            else
            begin
                 i := InstallUserDriver('$LJ',nil);
                 if i < 0 then
                 begin
                      Error_Message('Can not install LaserJet');
                      exit;
                 end;
                 GraphDriver := i;

                 if (RegisterBGIdriver(@LjDriverProc) < 0) then
                 begin
                      Error_message('Can not register LaserJet');
                      exit;
                 end;
            end;

            if Printer_res = 'LOW' then
            begin
                 moddd := PortLpt1 or LandLo;
                 message('Printing Graph to '+Printer_name,
                         'Low Resolution Graph may take several seconds',true);
            end
            else
            if Printer_res = 'MEDIUM' then
            begin
                 moddd := PortLpt1 or LandMed;
                 message('Printing Graph to '+Printer_name,
                         'Medium Resolution Graph may take a few minutes',true);
            end
            else
            begin
                 moddd := PortLpt1 or LandHi;
                 message('Printing Graph to '+Printer_name,
                         'High Resolution Graph may take several minutes',true);
            end;

            bInitGraph(GraphDriver,moddd,'',@info);

            if GraphResult <> 0 then
            begin
                 error_message(GraphErrorMsg(GraphResult));
                 exit;
            end;

            graphScreenDefaults(GraphDriver);
           {$ELSE}
            error_message('Program was compiled without printer support.');
            exit;
           {$ENDIF}
            code := oldcode;
       end;

       if code = 32 then
       begin
            mark_reach := not mark_reach;
            code := oldcode;
       end;

       if code = -66 then
       begin
            draw_grid := not draw_grid;
            code := oldcode;
       end;

       if code = 9 then
            if graph_type = sensitivity_plot then
               if nplots < max_plots then
               begin
                    nplots := nplots + 1;
                    code := oldcode;
               end;

       if code = -67 then
       begin
            hide_prompt := not hide_prompt;
            if hide_prompt then
            begin
                 SetFillStyle(SolidFill,BackC);
                 bar(2,ScrYmin+trunc(AbsMaxY*2*linewidth),trunc(AbsMaxX)-2,trunc(AbsMaxY)-2);
                 outtextxy(scrxmin-trunc(AbsMaxX*0.08),scrymin+trunc(AbsMaxY*2.5*linewidth),'Enter New Title:');
                 GetStringG(hide_title, scrXmin - trunc(AbsMaxX*0.08),scrYmin+trunc(AbsMaxY* 3.5* linewidth),70,[' '..'~']);
            end;

            tempC := BackC;
            BackC := OldC;
            OldC := TempC;
            code := oldcode;
       end;

       if  (Ch = 't') or (Ch = 'T') then
       begin
            two_plots := not two_plots;
            code := -59;
       end;

       if ((code <= -59) and (code >= -67)) or (code = 66) then
       begin
            { --- Changing order at request of DWD --- }
            oldcode := code;
            if code = -60 then code := -61
            else if code = -61 then code := -63
            else if code = -62 then code := -60
            else if code = -63 then code := -62
            else if code = 66  then code := -66;
            graph_part(abs(code) -  58);
       end;

       if not hardcopy then
          getchar;
  end;

  CloseGraph;

end; { end show graph }

end.   { end implementation }
