{ ------------------------------------------------------------------ }
{ -- The following file contains miscellaneous data for SMPTX3 ----- }
{ -- This file should be used by all other SMPTX3 units  ----------- }
{ ------------------------------------------------------------------ }


{ ----------------------- Created 10/19/90 by DC ---------------------------- }
{ ------------------------- Modification lists ------------------------------ }

{ 1/3/91  Adding different modelling complexity - DC }

{ -------------------------------------------------------------------------- }
{ -------------------------------------------------------------------------- }
unit stx3_msc;

interface

uses crt,textutil,stx3_var;

VAR
     {  Misc Variables }
Infile_name         : textstr;
outfile_name        : textstr;
in_directory        : textstr;    { directory for file I/o }
Facility_Name       : array[0..Max_reaches] of textstr;
Stream_Name         : textstr;
Upstream_River_mile : real;
Number_discharges   : integer;
Number_reaches      : integer;
Pollutant_name      : textstr;
Pollutant_units     : textstr;
scaling_factor      : real;
Display_title       : textstr;
Observations        : array[0..7,1..Max_Observations] of real;
Discharge_number    : array[0..Max_Reaches] of integer;           { Pointers to top of reach }
total_q             : reach_var;                                  { Cumulative flow }
r_length            : reach_var;                                  { reach length in miles }
upstream_com        : array[1..5] of string[25];                  { upstream comments }
effluent_com        : array[1..Max_reaches,1..5] of string[25];   { effluent comments }
reach_com           : array[1..Max_reaches,1..15] of string[25];  { reach comments }
need_disk           : boolean;                                    { flag for whether results were
                                                                    written to disk }
graph_type          : integer;                                    { used to store graph_type }
model_type          : integer;                                    { used to indicate model complexity }
high_model          : integer;                                    { used to indicate model_type in many_model }
standard            : array[0..3,0..Max_reaches] of real;
number_standards    : integer;
Printer_name        : textstr;
Printer_res         : textstr;

   { Output Variables }
run_m1      : real;                            { most recently calculated m1 }
run_ct      : real;                            { most recently calculated ct }
sense_out   : array[1..15] of real;            { holds sensitivity analysis changes }
sense_name  : array[0..Max_graphs] of textstr; { names of sensitivity analysis }
files       : array[1..Max_graphs] of textstr; { saved for multiple simulations }
directories : array[1..Max_graphs] of textstr;
nf          : integer;
last_buf    : integer;
total_buf   : integer;
graph_buf   : array[1..Max_graphs] of^graphics_buffer;
first_time_f : Boolean;

procedure Setup_Variables;

implementation

  procedure Setup_Variables;
  var i,j : integer;
  begin
       for i := 0 to Max_Reaches do
       begin
            for j := 1 to 2 do
            begin
                 ct[j,i] := 0.0;
                 cd[j,i] := 0.0;
                 cp[j,i] := 0.0;
                 m[j,i] := 0.0;
                 fd[j,i] := 0.0;
                 fp[j,i] := 0.0;
                 pc[j,i] := 0.0;
                 h [j,i] := 0.0;
                 kd[j,i] := 0.0;
                 kp[j,i] := 0.0;
                 k [j,i] := 0.0;
                 dt[j,i]:=0.0;
            end;
            ws[i]:=0.0;
            wrs[i]:=0.0;
            wd[i]:=0.0;
            ks[i]:=0.0;
            a[i]:=0.0;
            q[i]:=0.0;
            u[i]:=0.0;
            wt[i]:=0.0;
            kl[i] := 0.0;
            ad[i] := 0.0;
            vl[i] := 0.0;
            discharge_number[i] :=Max_reaches;
            r_length[i] := 0.0;
            Facility_Name[i] := '';
       end;
       infile_name := '';
       outfile_name := '';
       in_directory := '';
       Stream_Name := '';
       Upstream_River_mile := 0.0;
       Number_discharges := 0;
       Number_reaches := 0;
       Pollutant_name := 'Toxicant';
       Pollutant_units := '';
       scaling_factor := 0;
       Display_title := '';
       last_buf := 0;
       total_buf := 0;
       number_standards := 0;
       Printer_name := 'NONE';
       Printer_res := 'NONE';

       for i := 1 to 14 do
           sense_out[i] := 0;

       for i :=1 to Max_reaches do
           for j:=1 to 15 do
           begin
               if j<=5 then
                  effluent_com[i,j] := '';
               reach_com[i,j] := '';
           end;

       for i:=1 to 5 do
           upstream_com[i] := '';

       for i := 0 to 7 do
           for j := 1 to Max_Observations do
               observations[i,j] := 0.0;

       for i := 0 to 3 do
           for j := 0 to max_reaches do
            standard[i,j] := 0.0;

       model_type := SMPTOX3;
       high_model := SMPTOX3;

  end;   { end setup_variables }

end.  { end implementatin }
