{ -------------------------------------------------------------------------- }
{ -- STX3_SCR.PAS file contains screen I/O definitions.  This unit calls --- }
{ -- procedures and references global variables contained in ScrnUtil. ----- }
{ -------------------------------------------------------------------------- }


{ ----------------------- Created 5/30/90 by DC ---------------------------- }
{ ------------------------- Modification lists ----------------------------- }

  { 5/30/90  Broke this unit out of Scrnutil - DC }
  { 5/31/90  Associating real inputs with screen_data - DC }
  { 6/4/90   Began adding output screen - DC }
  { 6/5/90   Debugged output screen - DC }
  { 6/7/90   Added Suspended solids to output screen - DC }
  { 6/12/90  Added Sensivity Analysis screen - DC }
  { 7/3/90   Adding modify discharge screen - DC }
  { 7/5/90   Still Adding screen - DC }
  { 7/10/90  Adding Analytical result to table output - DC }
  { 7/12/90  Changing standard a little - DC }
  { 8/1/90   Changing to single Edit Option - DC }
  { 1/3/91   Adding Modeling complexity option - DC }
  { 9/3/91   Changing Modeling display to just 1,2,3 - DC }
  { 9/3/91   Fixing Observational Data Bug - DC }
  { 10/10/91 Fixing set_point - DC }
  { 10/10/91 Fixing modify_discharge escaping - DC }

{ -------------------------------------------------------------------------- }
{ -------------------------------------------------------------------------- }
unit Stx3_scr;

interface

uses crt,textutil,stx3_var,stx3_msc,scrnutil;

procedure edit_river_data;                      { The data needed to use the model }
procedure view_table_output(out_file:textstr);  { View the results stored in graph_buf[1] }
function  edit_sense: integer;                  { Enter sensitivity analysis data }
function modify_discharge : integer;            { Enter standard and change effluent on the fly }
procedure unmodify_discharge;                   { Returns effluent to previous values }
procedure set_point(x : real;var temp:sfields);

implementation

  { --------------------------------------- }
  { -- rj right justifies string s -------- }
  { --------------------------------------- }
  function rj(s:string) : string;
  var i,j : integer;
  begin
       j := length(s);
       i := 1;
       rj := s;
       while (s[i] = ' ') and (i <= j) do
       begin
            rj := copy(s,i+1,j-i);
            i := i + 1;
       end;
  end;

  { -------------------------------------------- }
  { -- Upstring turns string s into uppercase -- }
  { -------------------------------------------- }
  function Upstring(s:string): string;
  var i,j : integer;
  begin
       j := length(s);
       for i:=1 to j do
           if (s[i] >= 'a') and (s[i] <= 'z') then
              s[i] := Upcase(s[i]);
       upstring := s;
  end;


  { ----------------------------------------------------------------- }
  { -- set point returns a string with an appropiate decimal point -- }
  { ----------------------------------------------------------------- }
  procedure set_point(x : real;var temp:sfields);
  var i,j : integer;
      flag,flag2: boolean;
      y : real;
      t2 : string;
  begin
	flag := FALSE;
        flag2 := FALSE;
        if x < 0 then
        begin
             x := -x;
             flag2 := TRUE;
        end;
	if x >= 100000 then
	begin
	     y := x;
	     i := 0;
	     while (y > 9.999) do
	     begin
	          y := y / 10.0;
		  i := i + 1;
	     end;
	     str(y:1:3,temp);
	     str(i,t2);
	     temp := temp + 'e'+t2;
	     flag := TRUE;
  	end
  	else
        if x >= 1000 then
           str(x:1:0,temp)
        else
        if x >= 100 then
          str(x:1:1,temp)
        else
        if x >= 10 then
           str(x:1:2,temp)
        else
        if x >= 0.1 then
           str(x:1:3,temp)
        else
        if x >= 0.01 then
           str(x:1:4,temp)
        else
        if x >= 0.001 then
           str(x:1:5,temp)
        else
	if x > 0 then
	begin
  	     y := x;
  	     i := 0;
	     while y < 0.9999 do
	     begin
	          y := y * 10.0;
		  i := i - 1;
	     end;
	     str(y:1:2,temp);
	     str(i,t2);
	     temp := temp + 'e'+t2;
	     flag := TRUE;
	end
	else
            str(x:1:0,temp);

        i := length(temp); j := Pos('.',temp);
	while (j > 0) and (temp[i] = '0') and (i>j) and (not flag) do
	begin
	     temp := copy(temp,1,i-1);
             i := i - 1;
        end;

        i := length(temp);
        if temp[i] = '.' then
           temp := copy(temp,1,i-1);

        if flag2 then
           temp := '-'+temp;

  end; { end set_point }

  var
     original_dt : global_var;                   { holder for discharge values }
		 i,j,discharger,reach : integer;
		 old_factor : real;
     buf : sfields;
     flag  : boolean;
     xpos, ypos : integer;

  { ------------------------------------------------------------------------- }
  { -- do_upstream initializes upstream variables  -------------------------- }
  { ------------------------------------------------------------------------- }
  procedure do_upstream;
  begin
       clear_screen_inputs;
       header_width := 1;
       xheaders[0] := 'Calibration';
       xheaders[1] := 'Parameters';
       xheaders[2] := 'Comments';

       if model_type = SMPTOX3 then
       begin
            yheaders[1] := 'Flow                        (cfs)  ';
            yheaders[3] := 'Suspended Solids Conc.      (mg/L) ';
            yheaders[4] := 'Bed Solids Concentration    (mg/L) ';
            yheaders[5] := 'River mile of upstream boundary    ';
            buf := copy('                             ',1,22-length(Pollutant_name));
            yheaders[2] := 'Total '+Pollutant_name + buf + '('+Pollutant_units+')';

            xdata_width[0] := length(yheaders[1])+1;

            i := length(yheaders[2]);
            if i >= xdata_width[0] then xdata_width[0] := i + 1;

            xdata_width[1] := 15;
            xdata_width[2] := 77-xdata_width[0]-xdata_width[1];
            for i := 1 to 5 do
                number_inputs[2][i] := FALSE;
            set_normal_returns;

            set_point(q[0],screen_data^[1,1]);   { upstream flow }
            set_point(ct[1,0],screen_data^[1,2]);    { upstream concentration }
            set_point(m[1,0],screen_data^[1,3]); { suspend solids concentration in water }
            set_point(m[2,0],screen_data^[1,4]); { bed solids concentration }
            set_point(upstream_river_mile,screen_data^[1,5]); { mile mark }
            for i := 1 to 5 do
            begin
                 if length(upstream_com[i]) >= xdata_width[2] then
                    upstream_com[i] := copy(upstream_com[i],1,xdata_width[2] - 2);
                 screen_data^[2,i] := upstream_com[i];
            end;

	    Screen_Type:=edit_screen('UPSTREAM RIVER PARAMETERS:  '+display_title,2,5,TRUE,xpos,ypos);

            if Screen_Type <> ESCAPE then
            begin
                 val(screen_data^[1,1],q[0],i);      { upstream flow }
                 val(screen_data^[1,2],ct[1,0],i);   { concentration }
                 val(screen_data^[1,3],m[1,0],i);    { suspend solids concentration }
                 val(screen_data^[1,4],m[2,0],i);    { bed solids concentration }
                 val(screen_data^[1,5],upstream_river_mile,i); { mile mark }

                 for i := 1 to 5 do
                     upstream_com[i] := rj(screen_data^[2,i]);
                 for i := 1 to max_reaches do
                     m[2,i] := m[2,0];

                 if m[2,0] <= 0 then
                 begin
                      error_message('Bed solids must be greater than 0.');
                      Screen_Type := Upstream_Screen;
                 end;

                 if upstream_river_mile <= 0 then
                 begin
                      error_message('Upstream River Mile must be greater than 0.');
                      Screen_Type := Upstream_Screen;
                 end;

                 if q[0] <= 0 then
                 begin
                      error_message('Upstream Flow must be greater than 0.');
                      Screen_Type := Upstream_Screen;
                 end;
                 if m[1,0] <= 0 then
                 begin
                      error_message('Suspended solids must be greater than 0.');
                      Screen_Type := Upstream_Screen;
                 end;
            end;
       end   { end model_type = SMPTOX3 }
       else
       if model_type = SMPTOX2 then
       begin
            yheaders[1] := 'Flow                        (cfs)  ';
            yheaders[3] := 'Suspended Solids Conc.      (mg/L) ';
            yheaders[4] := 'River mile of upstream boundary    ';
            buf := copy('                             ',1,22-length(Pollutant_name));
            yheaders[2] := 'Total '+Pollutant_name + buf + '('+Pollutant_units+')';

            xdata_width[0] := length(yheaders[1])+1;

            i := length(yheaders[2]);
            if i >= xdata_width[0] then xdata_width[0] := i + 1;

            xdata_width[1] := 15;
            xdata_width[2] := 77-xdata_width[0]-xdata_width[1];
            for i := 1 to 4 do
                number_inputs[2][i] := FALSE;
            set_normal_returns;

            set_point(q[0],screen_data^[1,1]);   { upstream flow }
            set_point(ct[1,0],screen_data^[1,2]);    { upstream concentration }
            set_point(m[1,0],screen_data^[1,3]); { suspend solids concentration in water }
            set_point(upstream_river_mile,screen_data^[1,4]); { mile mark }
            for i := 1 to 5 do
            begin
                 if length(upstream_com[i]) >= xdata_width[2] then
                    upstream_com[i] := copy(upstream_com[i],1,xdata_width[2] - 2);
                 screen_data^[2,i] := upstream_com[i];
            end;
            screen_data^[2,4] := upstream_com[5];

            Screen_Type:=edit_screen('UPSTREAM RIVER PARAMETERS:  '+display_title,2,4,TRUE,xpos,ypos);

            if Screen_Type <> ESCAPE then
            begin
                 val(screen_data^[1,1],q[0],i);      { upstream flow }
                 val(screen_data^[1,2],ct[1,0],i);   { concentration }
                 val(screen_data^[1,3],m[1,0],i);    { suspend solids concentration }
                 val(screen_data^[1,4],upstream_river_mile,i);
                 for i := 1 to 3 do
                     upstream_com[i] := rj(screen_data^[2,i]);
                 upstream_com[5] := rj(screen_data^[2,4]);

                 if upstream_river_mile <= 0 then
                 begin
                      error_message('Upstream River Mile must be greater than 0.');
                      Screen_Type := Upstream_Screen;
                 end;

                 if q[0] <= 0 then
                 begin
                      error_message('Upstream Flow must be greater than 0.');
                      Screen_Type := Upstream_Screen;
                 end;
            end;
       end  { end model_type = SMPTOX2 }
       else
       begin
            yheaders[1] := 'Flow                        (cfs)  ';
            yheaders[3] := 'River mile of upstream boundary    ';
            buf := copy('                             ',1,22-length(Pollutant_name));
            yheaders[2] := 'Total '+Pollutant_name + buf + '('+Pollutant_units+')';

            xdata_width[0] := length(yheaders[1])+1;

            i := length(yheaders[2]);
            if i >= xdata_width[0] then xdata_width[0] := i + 1;

            xdata_width[1] := 15;
            xdata_width[2] := 77-xdata_width[0]-xdata_width[1];
            for i := 1 to 3 do
                number_inputs[2][i] := FALSE;
            set_normal_returns;

            set_point(q[0],screen_data^[1,1]);   { upstream flow }
            set_point(ct[1,0],screen_data^[1,2]);    { upstream concentration }
            set_point(upstream_river_mile,screen_data^[1,3]); { mile mark }
            for i := 1 to 5 do
            begin
                 if length(upstream_com[i]) >= xdata_width[2] then
                    upstream_com[i] := copy(upstream_com[i],1,xdata_width[2] - 2);
                 screen_data^[2,i] := upstream_com[i];
            end;
            screen_data^[2,3] := upstream_com[5];

            Screen_Type:=edit_screen('UPSTREAM RIVER PARAMETERS:  '+display_title,2,3,TRUE,xpos,ypos);

            if Screen_Type <> ESCAPE then
            begin
                 val(screen_data^[1,1],q[0],i);      { upstream flow }
                 val(screen_data^[1,2],ct[1,0],i);   { concentration }
                 val(screen_data^[1,3],upstream_river_mile,i);
                 for i := 1 to 3 do
                     upstream_com[i] := rj(screen_data^[2,i]);

                 if q[0] <= 0 then
                 begin
                      error_message('Upstream Flow must be greater than 0.');
                      Screen_Type := Upstream_Screen;
                 end;
                 if upstream_river_mile <= 0 then
                 begin
                      error_message('Upstream River Mile must be greater than 0.');
                      Screen_Type := Upstream_Screen;
                 end;
            end;
       end; { end model_type = SMPTOX1 }
  end;  { end do_upstream }

  { ------------------------------------------------------------------------- }
  { -- do_effluent initializes discharge variables -------------------------- }
  { ------------------------------------------------------------------------- }
  procedure do_effluent;
  begin
        clear_screen_inputs;
        discharger := 1;
        header_width := 1;

       if (model_type = SMPTOX3) or (model_type = SMPTOX2) then
       begin
            yheaders[1] := 'Flow                     (MGD)  ';
            yheaders[3] := 'Suspended Solids Conc.   (mg/L) ';
            yheaders[4] := 'Beginning of Reach Number       ';
            yheaders[5] := 'Name of Discharger              ';
            buf := copy('                             ',1,19-length(Pollutant_name));
            yheaders[2] := 'Total ' + Pollutant_name + buf + '('+Pollutant_units+')';

            xdata_width[0] := length(yheaders[1])+1;
            i := length(yheaders[2]);
            if i >= xdata_width[0] then xdata_width[0] := i +1;
            xdata_width[1] := 13;
            xdata_width[2] := 77-xdata_width[0]-xdata_width[1];

            number_inputs[1][5] := False;
            for i := 1 to 5 do
                number_inputs[2][i] := FALSE;

            set_normal_returns;
            valid_returns[Page_up] := TRUE;
            Valid_Returns[Page_down] := TRUE;

            while (Screen_Type = Page_up) or (Screen_type = Page_Down)
                  or (Screen_Type = Effluent_Screen) do
            begin
                 Screen_Type := Effluent_Screen;

                 xheaders[0] := 'Calibration';
                 xheaders[2] := 'Comments';
                 xheaders[1] := 'Parameter';

                 { fill screen with variable data }
                 set_point(q[discharge_number[discharger]],screen_data^[1,1]);    { pipe flow }
                 set_point(dt[1,discharge_number[discharger]],screen_data^[1,2]); { pipe concentration }
                 set_point(m[1,discharge_number[discharger]],screen_data^[1,3]);  { suspend solids }
                 str(discharge_number[discharger],screen_data^[1,4]);           { associated reach }
                 screen_data^[1,5] := facility_name[discharge_number[discharger]];   { name }

                 j := discharge_number[discharger];
                 for i := 1 to 5 do
                 begin
                      if length(effluent_com[j,i]) >= xdata_width[2] then
                         effluent_com[j,i] := copy(effluent_com[j,i],1,xdata_width[2] -2);
                     screen_data^[2,i] := effluent_com[j,i];
                 end;


                 str(discharger,buf);

                 Screen_Type:=edit_screen('EFFLUENT PARAMETERS FOR DISCHARGE '+BUF+':  '+display_title,
                                                    2,5,TRUE,xpos,ypos);

                 val(screen_data^[1,4],i,j);
                 if Screen_Type <> Escape then
                 begin
                      if (i>0) and (i<=number_reaches) then
                      begin
                           { fill variables with screen data }
                           val(screen_data^[1,4],discharge_number[discharger],j);
                           val(screen_data^[1,3],m[1,discharge_number[discharger]],j);
                           val(screen_data^[1,2],dt[1,discharge_number[discharger]],j);
                           val(screen_data^[1,1],q[discharge_number[discharger]],j);
                           facility_name[discharge_number[discharger]] := rj(screen_data^[1,5]);
                           for i := 1 to 5 do
                               effluent_com[discharge_number[discharger],i] := rj(screen_data^[2,i]);
                      end
                      else
                      begin
                           error_message('Each discharger must be associated with a reach');
                           Screen_type := Effluent_screen;
                      end;
                 end;

                 if (discharge_number[discharger] >0)
                 and (discharge_number[discharger] <= number_reaches) then
                 case Screen_type of
                      Page_up : if (discharger >1) then
                              Discharger := Discharger - 1
                              else Discharger := Number_discharges;
                      Page_down : if discharger < Number_discharges then
                                Discharger := Discharger + 1
                                else discharger := 1;
                      Effluent_Screen : discharger := 1;
                 end;  { end case }

            end; { end while }

            if screen_type <> Effluent_screen then
                 for i := 1 to number_reaches do
                 begin
                      flag := false;
                      for j := 1 to number_discharges do
                          if discharge_number[j] = i then
                             flag := true;
                      if not flag then
                      begin
                           q[i]:=0.0;
                           dt[1,i] := 0.0;
                           m[1,i] := 0.0;
                           for j := 1 to 5 do
                               effluent_com[i,j] := '';
                      end;
                 end;
       end { end SMPTOX3 or SMPTOX2 }
       else
       begin
            yheaders[1] := 'Flow                     (MGD)  ';
            yheaders[3] := 'Beginning of Reach Number       ';
            yheaders[4] := 'Name of Discharger              ';
            buf := copy('                             ',1,19-length(Pollutant_name));
            yheaders[2] := 'Total ' + Pollutant_name + buf + '('+Pollutant_units+')';

            xdata_width[0] := length(yheaders[1])+1;
            i := length(yheaders[2]);
            if i >= xdata_width[0] then xdata_width[0] := i +1;
            xdata_width[1] := 13;
            xdata_width[2] := 77-xdata_width[0]-xdata_width[1];

            number_inputs[1][4] := False;
            for i := 1 to 4 do
                number_inputs[2][i] := FALSE;

            set_normal_returns;
            valid_returns[Page_up] := TRUE;
            Valid_Returns[Page_down] := TRUE;

            while (Screen_Type = Page_up) or (Screen_type = Page_Down)
                  or (Screen_Type = Effluent_Screen) do
            begin
                 Screen_Type := Effluent_Screen;

                 xheaders[0] := 'Calibration';
                 xheaders[2] := 'Comments';
                 xheaders[1] := 'Parameter';

                 { fill screen with variable data }
                 set_point(q[discharge_number[discharger]],screen_data^[1,1]);    { pipe flow }
                 set_point(dt[1,discharge_number[discharger]],screen_data^[1,2]); { pipe concentration }
                 str(discharge_number[discharger],screen_data^[1,3]);           { associated reach }
                 screen_data^[1,4] := facility_name[discharge_number[discharger]];   { name }

                 j := discharge_number[discharger];
                 for i := 1 to 5 do
                 begin
                      if length(effluent_com[j,i]) >= xdata_width[2] then
                         effluent_com[j,i] := copy(effluent_com[j,i],1,xdata_width[2] -2);
                     screen_data^[2,i] := effluent_com[j,i];
                 end;
                 screen_data^[2,1] := effluent_com[j,1];
                 screen_data^[2,2] := effluent_com[j,2];
                 screen_data^[2,3] := effluent_com[j,4];
                 screen_data^[2,4] := effluent_com[j,5];


                 str(discharger,buf);

                 Screen_Type:=edit_screen('EFFLUENT PARAMETERS FOR DISCHARGE '+BUF+':  '+display_title,
                                                    2,4,TRUE,xpos,ypos);

                 val(screen_data^[1,3],i,j);
                 if Screen_Type <> Escape then
                 begin
                      if (i>0) and (i<=number_reaches) then
                      begin
                           { fill variables with screen data }
                           val(screen_data^[1,3],discharge_number[discharger],j);
                           val(screen_data^[1,2],dt[1,discharge_number[discharger]],j);
                           val(screen_data^[1,1],q[discharge_number[discharger]],j);
                           facility_name[discharge_number[discharger]] := rj(screen_data^[1,4]);
                           for i := 1 to 2 do
                               effluent_com[discharge_number[discharger],i] := rj(screen_data^[2,i]);
                           effluent_com[discharge_number[discharger],4] := rj(screen_data^[2,3]);
                           effluent_com[discharge_number[discharger],5] := rj(screen_data^[2,4]);

                      end
                      else
                      begin
                           error_message('Each discharger must be associated with a reach');
                           Screen_type := Effluent_screen;
                      end;
                 end;

                 if (discharge_number[discharger] >0)
                 and (discharge_number[discharger] <= number_reaches) then
                 case Screen_type of
                      Page_up : if (discharger >1) then
                              Discharger := Discharger - 1
                              else Discharger := Number_discharges;
                      Page_down : if discharger < Number_discharges then
                                Discharger := Discharger + 1
                                else discharger := 1;
                      Effluent_Screen : discharger := 1;
                 end;  { end case }

            end; { end while }

            if screen_type <> Effluent_screen then
                 for i := 1 to number_reaches do
                 begin
                      flag := false;
                      for j := 1 to number_discharges do
                          if discharge_number[j] = i then
                             flag := true;
                      if not flag then
                      begin
                           q[i]:=0.0;
                           dt[1,i] := 0.0;
                           m[1,i] := 0.0;
                           for j := 1 to 5 do
                               effluent_com[i,j] := '';
                      end;
                 end;
       end; {end SMPTOX }

  end; { end do_effluent }

  { ------------------------------------------------------------------------- }
	{ -- alt_r reach variables ------------------------------------------------ }
	{ ------------------------------------------------------------------------- }
	procedure alt_r;
	begin
				if model_type = SMPTOX3 then
				begin
						 if ypos = 1 then
							 for i:=0 to number_reaches do
								 r_length[i] := r_length[reach];
						 if ypos = 2 then
							 for i:=0 to number_reaches do
								 h[1,i] := h[1,reach];
						 if ypos = 3 then
							 for i:=0 to number_reaches do
								 u[i] := u[reach];
						 if ypos = 4 then
							 for i:=0 to number_reaches do
								 kp[1,i] := kp[1,reach];
						 if ypos = 5 then
							 for i:=0 to number_reaches do
								 kd[1,i] := kd[1,reach];
						 if ypos = 6 then
							 for i:=0 to number_reaches do
								 vl[i] := vl[reach];
						 if ypos = 7 then
							 for i:=0 to number_reaches do
								 kp[2,i] := kp[2,reach];
						 if ypos = 8 then
							 for i:=0 to number_reaches do
								 kd[2,i] := kd[2,reach];
						 if ypos = 9 then
							 for i:=0 to number_reaches do
								 ws[i] := ws[reach];
						 if ypos = 10 then
							 for i:=0 to number_reaches do
								 wrs[i] := wrs[reach];
						 if ypos = 11 then
							 for i:=0 to number_reaches do
								 pc[1,i] := pc[1,reach];
						 if ypos = 12 then
							 for i:=0 to number_reaches do
								 pc[2,i] := pc[2,reach];
						 if ypos = 13 then
							 for i:=0 to number_reaches do
								 h[2,i] := h[2,reach];
						 if ypos = 14 then
							 for i:=0 to number_reaches do
								 kl[i] := kl[reach];
						 if ypos = 15 then
							 for i:=0 to number_reaches do
								 ad[i] := ad[reach];
				end
				else
				if model_type = SMPTOX2 then
				begin
						 if ypos = 1 then
							 for i:=0 to number_reaches do
								 r_length[i] := r_length[reach];
						 if ypos = 2 then
							 for i:=0 to number_reaches do
								 u[i] := u[reach];
						 if ypos = 3 then
							 for i:=0 to number_reaches do
								 kd[1,i] := kd[1,reach];
						 if ypos = 4 then
							 for i:=0 to number_reaches do
								 ws[i] := ws[reach];
						 if ypos = 5 then
							 for i:=0 to number_reaches do
								 pc[1,i] := pc[1,reach];
				end
				else
				begin
						 if ypos = 1 then
							 for i:=0 to number_reaches do
								 r_length[i] := r_length[reach];
						 if ypos = 2 then
							 for i:=0 to number_reaches do
								 u[i] := u[reach];
						 if ypos = 3 then
							 for i:=0 to number_reaches do
								 kd[1,i] := kd[1,reach];
				end;
	end;

  { ------------------------------------------------------------------------- }
  { -- do_reach initializes reach variables --------------------------------- }
  { ------------------------------------------------------------------------- }
	procedure do_reach;
  begin
       clear_screen_inputs;
       header_width := 1;
       reach := 1;
       xheaders[0] := 'Calibration';
			 xheaders[2] := 'Comments';
			 valid_returns[RRepeat]  := TRUE;

       if model_type = SMPTOX3 then
       begin
            yheaders[1] := 'Length                             (mile) ';
            yheaders[2] := 'Average Depth                      (feet) ';
            yheaders[3] := 'Velocity                            (fps) ';
            yheaders[4] := 'Water Col. Particulate Decay rate (1/day) ';
            yheaders[5] := 'Water Col. Dissolved Decay rate   (1/day) ';
            yheaders[6] := 'Volatilization                    (1/day) ';
            yheaders[7] := 'Bed Particulate Decay Rate        (1/day) ';
            yheaders[8] := 'Bed Dissolved Decay Rate          (1/day) ';
            yheaders[9] := 'Sus. Solids Settling Velocity     (m/day) ';
            yheaders[10] := 'Bed Solids Resuspension Velocity  (m/day) ';
            yheaders[11] := 'Water Col. Partition Coefficient   (L/mg) ';
            yheaders[12] := 'Bed Partition Coefficient          (L/mg) ';
            yheaders[13] := 'Active Bed Depth                   (feet) ';
	    yheaders[14] := 'Diffusive Exchange Coefficient    (m/day) ';

	    if scaling_factor > 2000000000.0 then
		    yheaders[15] := 'Atmospheric Deposition      (ng/mile/day) '
	    else if scaling_factor > 2000000.0 then
		    yheaders[15] := 'Atmospheric Deposition      (ug/mile/day) '
	    else if scaling_factor > 2000.0 then
		    yheaders[15] := 'Atmospheric Deposition      (mg/mile/day) '
	    else
		    yheaders[15] := 'Atmospheric Deposition       (g/mile/day) ';

            xdata_width[0] := length(yheaders[1])+1;
            xdata_width[1] := 12;
            xdata_width[2] := 77-xdata_width[0]-xdata_width[1];

            for i := 1 to 15 do
                number_inputs[2][i] := FALSE;

            set_normal_returns;

            valid_returns[Page_up] := TRUE;
						Valid_Returns[Page_down] := TRUE;

            while (screen_type = Page_Up) or (Screen_Type = Page_Down)
                  or (screen_type = Reach_Screen) do
            begin
                 Screen_type := Reach_Screen;
                 xheaders[1] := 'Parameter';
                 xheaders[0] := 'Calibration';
                 xheaders[2] := 'Comments';

                     { fill screen with variable data }

                 set_point(r_length[reach],screen_data^[1,1]);    { reach length }
                 set_point(h[1,reach],screen_data^[1,2]);         { Averge Depth }
                 set_point(u[reach],screen_data^[1,3]);           { velocity }
                 set_point(kp[1,reach],screen_data^[1,4]);         { WC decay rate }
                 set_point(kd[1,reach],screen_data^[1,5]);         { WC decay rate }
                 set_point(vl[reach],screen_data^[1,6]);           { volatilization }
                 set_point(kp[2,reach],screen_data^[1,7]);         { WC decay rate }
                 set_point(kd[2,reach],screen_data^[1,8]);         { WC decay rate }
                 set_point(ws[reach],screen_data^[1,9]);          { Settling rate }
                 set_point(wrs[reach],screen_data^[1,10]);         { Resuspension rate }
                 set_point(pc[1,reach],screen_data^[1,11]);        { WC partition Coef }
                 set_point(pc[2,reach],screen_data^[1,12]);        { Sed partition Coef }
                 set_point(h[2,reach],screen_data^[1,13]);        { Active Sed depth }
                 set_point(kl[reach],screen_data^[1,14]);         { Diffusive exchange Coeff }
                 set_point(ad[reach],screen_data^[1,15]);         { Atmosperhic Depos  ition }
                 for i := 1 to 15 do
                 begin
                      if length(reach_com[reach,i]) >= xdata_width[2] then
                         reach_com[reach,i] := copy(reach_com[reach,i],1,xdata_width[2] -2);
                     screen_data^[2,i] := reach_com[reach,i];
                 end;

                 str(reach,buf);
                 Screen_Type:=edit_screen('REACH PARAMETERS FOR REACH '+BUF+':  '+display_title,2,15,FALSE,xpos,ypos);

								 if Screen_Type <> Escape then
                 begin
                      { fill variables with screen data}
                      val(screen_data^[1,1],r_length[reach],j);    { reach length }
                      val(screen_data^[1,2],h[1,reach],j);         { Averge Depth }
                      val(screen_data^[1,3],u[reach],j);           { velocity }
                      val(screen_data^[1,4],kp[1,reach],j);        { WC decay rate }
                      val(screen_data^[1,5],kd[1,reach],j);        { WC decay rate }
                      val(screen_data^[1,6],vl[reach],j);          { WC decay rate }
                      val(screen_data^[1,7],kp[2,reach],j);        { WC decay rate }
                      val(screen_data^[1,8],kd[2,reach],j);        { WC decay rate }
                      val(screen_data^[1,9],ws[reach],j);          { Settling rate }
                      val(screen_data^[1,10],wrs[reach],j);         { Resuspension rate }
                      val(screen_data^[1,11],pc[1,reach],j);        { WC partition Coef }
                      val(screen_data^[1,12],pc[2,reach],j);        { Sed partition Coef }
                      val(screen_data^[1,13],h[2,reach],j);        { Active Sed depth }
                      val(screen_data^[1,14],kl[reach],j);         { Diffusive exchange Coeff }
                      val(screen_data^[1,15],ad[reach],j);         { Atmospheric Depostition }
                      for i := 1 to 15 do
                          reach_com[reach,i] := rj(screen_data^[2,i]);
                      flag := false;

                      if r_length[reach] <=0 then
                      begin
                           flag := TRUE;
                           error_message('Reach Length must be a postive value');
                           screen_type := Reach_screen;
                      end;

                      if h[1,reach] <=0 then
                      begin
                           flag := TRUE;
                           error_message('Average Depth must be a postive value');
                           screen_type := Reach_screen;
                      end;

                      if u[reach] <=0 then
                      begin
                           flag := TRUE;
                           error_message('Velocity must be a postive value');
                           screen_type := Reach_screen;
                      end;

                      if Ws[reach] <=0 then
                      begin
                           flag := TRUE;
                           error_message('Settling Velocity must be a postive value');
                           screen_type := Reach_screen;
                      end;

                      if (pc[2,reach] <=0) and (pc[1,reach] <> 0) then
                      begin
                           flag := TRUE;
                           error_message('Water Columm Partition Coefficient must be 0, if Bed P.C. is 0');
                           screen_type := Reach_screen;
                      end;

                      if (pc[1,reach] <=0) and (pc[2,reach] <> 0) then
                      begin
                           flag := TRUE;
                           error_message('Bed Partition Coefficient must be 0, if Water Column P.C. is 0');
                           screen_type := Reach_screen;
                      end;

                      if H[2,reach] <=0 then
                      begin
                           flag := TRUE;
                           error_message('Active Bed Depth must be a postive value');
                           screen_type := Reach_screen;
                      end;

										 if Screen_Type = RRepeat then
										 begin
													alt_r;
													flag := TRUE;
													Screen_type := reach_screen;
										 end;

                      if not flag then
                      case Screen_type of
                           Page_up : if reach >1 then
                                   reach := reach - 1
                                   else reach := number_reaches;
                           Page_down : if reach < Number_reaches then
                                     reach := reach + 1
                                     else reach := 1;
                           reach_Screen : reach := 1;
                      end;  { end case }
                 end;
            end; { end while }
       end { end SMPTOX3 }
       else if model_type = SMPTOX2 then
       begin
            yheaders[1] := 'Length                             (mile) ';
            yheaders[2] := 'Velocity                            (fps) ';
            yheaders[3] := 'Dissolved Decay rate              (1/day) ';
						yheaders[4] := 'Sus. Solids Settling Rate         (1/day) ';
            yheaders[5] := 'Partition Coefficient              (L/mg) ';

            xdata_width[0] := length(yheaders[1])+1;
            xdata_width[1] := 12;
            xdata_width[2] := 77-xdata_width[0]-xdata_width[1];

            for i := 1 to 5 do
                number_inputs[2][i] := FALSE;

            set_normal_returns;

            valid_returns[Page_up] := TRUE;
            Valid_Returns[Page_down] := TRUE;

            while (screen_type = Page_Up) or (Screen_Type = Page_Down)
                  or (screen_type = Reach_Screen) do
            begin
                 Screen_type := Reach_Screen;
                 xheaders[1] := 'Parameter';
                 xheaders[0] := 'Calibration';
                 xheaders[2] := 'Comments';

                     { fill screen with variable data }

                 set_point(r_length[reach],screen_data^[1,1]);    { reach length }
                 set_point(u[reach],screen_data^[1,2]);           { velocity }
                 set_point(kd[1,reach],screen_data^[1,3]);         { WC decay rate }
                 set_point(ws[reach],screen_data^[1,4]);          { Settling rate }
                 set_point(pc[1,reach],screen_data^[1,5]);        { WC partition Coef }
                 for i := 1 to 11 do
                 begin
                      if length(reach_com[reach,i]) >= xdata_width[2] then
                         reach_com[reach,i] := copy(reach_com[reach,i],1,xdata_width[2] -2);
                 end;
                 screen_data^[2,1] := reach_com[reach,1];
                 screen_data^[2,2] := reach_com[reach,3];
                 screen_data^[2,3] := reach_com[reach,5];
                 screen_data^[2,4] := reach_com[reach,9];
                 screen_data^[2,5] := reach_com[reach,11];

                 str(reach,buf);
                 Screen_Type:=edit_screen('REACH PARAMETERS FOR REACH '+BUF+':  '+display_title,2,5,TRUE,xpos,ypos);

                 if Screen_Type <> Escape then
                 begin
											{ fill variables with screen data}
											val(screen_data^[1,1],r_length[reach],j);    { reach length }
											val(screen_data^[1,2],u[reach],j);           { velocity }
											val(screen_data^[1,3],kd[1,reach],j);        { WC decay rate }
											val(screen_data^[1,4],ws[reach],j);          { Settling rate }
											val(screen_data^[1,5],pc[1,reach],j);        { WC partition Coef }
											reach_com[reach,1] := rj(screen_data^[2,1]);
											reach_com[reach,3] := rj(screen_data^[2,2]);
											reach_com[reach,5] := rj(screen_data^[2,3]);
											reach_com[reach,9] := rj(screen_data^[2,4]);
											reach_com[reach,11] := rj(screen_data^[2,5]);
											flag := false;

                      if r_length[reach] <=0 then
                      begin
                           flag := TRUE;
                           error_message('Reach Length must be a postive value');
                           screen_type := Reach_screen;
                      end;

                      if u[reach] <=0 then
                      begin
                           flag := TRUE;
                           error_message('Velocity must be a postive value');
                           screen_type := Reach_screen;
                      end;

		      if Screen_Type = RRepeat then
		      begin
		           alt_r;
			   flag := TRUE;
			   Screen_type := reach_screen;
		      end;

											if not flag then
                      case Screen_type of
                           Page_up : if reach >1 then
                                   reach := reach - 1
                                   else reach := number_reaches;
                           Page_down : if reach < Number_reaches then
                                     reach := reach + 1
                                     else reach := 1;
                           reach_Screen : reach := 1;
                      end;  { end case }
                 end;
            end; { end while }
       end { end SMPTOX2 }
       else
       begin
            yheaders[1] := 'Length                             (mile) ';
            yheaders[2] := 'Velocity                            (fps) ';
            yheaders[3] := 'Total Loss rate                   (1/day) ';

            xdata_width[0] := length(yheaders[1])+1;
            xdata_width[1] := 12;
            xdata_width[2] := 77-xdata_width[0]-xdata_width[1];

            for i := 1 to 5 do
                number_inputs[2][i] := FALSE;

            set_normal_returns;

            valid_returns[Page_up] := TRUE;
            Valid_Returns[Page_down] := TRUE;

            while (screen_type = Page_Up) or (Screen_Type = Page_Down)
                  or (screen_type = Reach_Screen) do
            begin
                 Screen_type := Reach_Screen;
                 xheaders[1] := 'Parameter';
                 xheaders[0] := 'Calibration';
                 xheaders[2] := 'Comments';

                     { fill screen with variable data }

                 set_point(r_length[reach],screen_data^[1,1]);    { reach length }
                 set_point(u[reach],screen_data^[1,2]);           { velocity }
                 set_point(kd[1,reach],screen_data^[1,3]);         { WC decay rate }
                 for i := 1 to 5 do
                 begin
                      if length(reach_com[reach,i]) >= xdata_width[2] then
                         reach_com[reach,i] := copy(reach_com[reach,i],1,xdata_width[2] -2);
                 end;
                 screen_data^[2,1] := reach_com[reach,1];
                 screen_data^[2,2] := reach_com[reach,3];
                 screen_data^[2,3] := reach_com[reach,5];

                 str(reach,buf);
                 Screen_Type:=edit_screen('REACH PARAMETERS FOR REACH '+BUF+':  '+display_title,2,3,TRUE,xpos,ypos);

                 if Screen_Type <> Escape then
                 begin
                      { fill variables with screen data}
                      val(screen_data^[1,1],r_length[reach],j);    { reach length }
                      val(screen_data^[1,2],u[reach],j);           { velocity }
                      val(screen_data^[1,3],kd[1,reach],j);        { WC decay rate }
                      reach_com[reach,1] := rj(screen_data^[2,1]);
                      reach_com[reach,3] := rj(screen_data^[2,2]);
                      reach_com[reach,5] := rj(screen_data^[2,3]);
                      flag := false;

                      if r_length[reach] <=0 then
                      begin
                           flag := TRUE;
                           error_message('Reach Length must be a postive value');
                           screen_type := Reach_screen;
                      end;

                      if u[reach] <=0 then
                      begin
                           flag := TRUE;
                           error_message('Velocity must be a postive value');
                           screen_type := Reach_screen;
                      end;

		      if Screen_Type = RRepeat then
		      begin
		           alt_r;
			   flag := TRUE;
			   Screen_type := reach_screen;
		      end;

		      if not flag then
                      case Screen_type of
                           Page_up : if reach >1 then
                                   reach := reach - 1
                                   else reach := number_reaches;
                           Page_down : if reach < Number_reaches then
                                     reach := reach + 1
                                     else reach := 1;
                           reach_Screen : reach := 1;
                      end;  { end case }
                 end;
            end; { end while }
			 end; { end SMPTOX }
	end; { end do_reach }

  { ------------------------------------------------------------------------- }
  { -- do_observed initializes observed variables --------------------------- }
  { ------------------------------------------------------------------------- }
  procedure do_observed;
  begin
       clear_screen_inputs;
  		 if model_type = SMPTOX3 then
  		 begin
            header_width := 3;
            xheaders[0] := '  ';
            xheaders[1] := 'River Mile';
            xheaders[2] := 'Diss. Water '+ Pollutant_name+' ('+Pollutant_units+')';
            xheaders[3] := 'Diss. Bed '+ Pollutant_name+' ('+Pollutant_units+')';
            xheaders[4] := 'Total Water '+ Pollutant_name+' ('+Pollutant_units+')';
            xheaders[5] := 'Total Bed '+ Pollutant_name+' ('+Pollutant_units+')';
            xheaders[6] := 'Suspended Solids (mg/L)';
            for i := 1 to Max_Y_Headers do
                str(i,yheaders[i]);
            xdata_width[0] := length(xheaders[0])+1;
            xdata_width[1] := 8;
            xdata_width[2] := 13;
            xdata_width[3] := 13;
            xdata_width[4] := 15;
            xdata_width[5] := 15;
            xdata_width[6] := 10;
            set_normal_returns;
            for i := 1 to Max_y_headers do
            begin
                 set_point(observations[0,i], screen_data^[1,i]);
                 set_point(observations[3,i],screen_data^[2,i]);
                 set_point(observations[4,i],screen_data^[3,i]);
                 set_point(observations[1,i],screen_data^[4,i]);
                 set_point(observations[2,i],screen_data^[5,i]);
                 set_point(observations[7,i],screen_data^[6,i]);
             end;

             if m[2,1] <= 0 then
             begin
                error_message('Error: Must Set Upstream Parameters Prior to Observations');
                screen_type := Upstream_screen;
                exit;
             end;
             Screen_Type:=edit_screen('OBSERVED RIVER DATA:  '+display_title,6,Max_y_headers,FALSE,xpos,ypos);

             if Screen_Type <> ESCAPE then
             begin
                  for i := 1 to Max_y_headers do
                  begin
                     val(screen_data^[1,i],observations[0,i],j);
                     val(screen_data^[2,i],observations[3,i],j);
                     val(screen_data^[3,i],observations[4,i],j);
                     val(screen_data^[4,i],observations[1,i],j);
                     val(screen_data^[5,i],observations[2,i],j);
                     val(screen_data^[6,i],observations[7,i],j);
                     observations[5,i] := (observations[1,i] - observations[3,i]);
                     if m[2,1] <= 0 then
                     begin
                          Error_message('Upstream Data Must Be Set Prior to Observations');
                          screen_type := upstream_screen;
                     end
                     else
                     if scaling_factor < 2000.0 then
                        observations[6,i] := (observations[2,i] - observations[4,i]) *1000.0 / m[2,1]  { for ug / mg }
                     else if scaling_factor < 2000000.0 then
                        observations[6,i] := (observations[2,i] - observations[4,i])  / m[2,1]  { for ug / mg }
                     else if scaling_factor < 2000000000.0 then
                        observations[6,i] := (observations[2,i] - observations[4,i]) / (1000.0 * m[2,1])  { for ug / mg }
                     else
                        observations[6,i] := (observations[2,i] - observations[4,i]) / (m[2,1]);  { for pg / mg }
                  end;
             end;
       end { end model_type = SMPTOX3 }
       else 
       if model_type = SMPTOX2 then 
       begin
            header_width := 2;
            xheaders[0] := '  ';
            xheaders[1] := 'River Mile';
            xheaders[2] := 'Diss. Water '+ Pollutant_name+' ('+Pollutant_units+')';
            xheaders[3] := 'Total Water '+ Pollutant_name+' ('+Pollutant_units+')';
            xheaders[4] := 'Suspended Solids (mg/L)';
            for i := 1 to Max_Y_Headers do
                str(i,yheaders[i]);
            xdata_width[0] := length(xheaders[0])+1;
            xdata_width[1] := 8;
            xdata_width[2] := 20;
            xdata_width[3] := 20;
            xdata_width[4] := 20;
            set_normal_returns;
            for i := 1 to Max_y_headers do
            begin
                 set_point(observations[0,i], screen_data^[1,i]);
                 set_point(observations[3,i],screen_data^[2,i]);
                 set_point(observations[1,i],screen_data^[3,i]);
                 set_point(observations[7,i],screen_data^[4,i]);
             end;

             Screen_Type:=edit_screen('OBSERVED RIVER DATA:  '+display_title,4,Max_y_headers,FALSE,xpos,ypos);

             if Screen_Type <> ESCAPE then
                for i := 1 to Max_y_headers do
                begin
                     val(screen_data^[1,i],observations[0,i],j);
                     val(screen_data^[2,i],observations[3,i],j);
                     val(screen_data^[3,i],observations[1,i],j);
                     val(screen_data^[4,i],observations[7,i],j);
                     observations[5,i] := (observations[1,i] - observations[3,i]);
                end;
       			
       end { end model_type = SMPTOX2 }
       else
       begin
            header_width := 1;
            xheaders[0] := '  ';
            xheaders[1] := 'River Mile';
            xheaders[2] := 'Total Water '+ Pollutant_name+' ('+Pollutant_units+')';
            for i := 1 to Max_Y_Headers do
                str(i,yheaders[i]);
            xdata_width[0] := length(xheaders[0])+1;
            xdata_width[1] := 15;
            xdata_width[2] := 50;
            set_normal_returns;
            for i := 1 to Max_y_headers do
            begin
                 set_point(observations[0,i], screen_data^[1,i]);
                 set_point(observations[1,i],screen_data^[2,i]);
             end;

             Screen_Type:=edit_screen('OBSERVED RIVER DATA:  '+display_title,2,Max_y_headers,FALSE,xpos,ypos);

             if Screen_Type <> ESCAPE then
                for i := 1 to Max_y_headers do
                begin
                     val(screen_data^[1,i],observations[0,i],j);
                     val(screen_data^[2,i],observations[1,i],j);
                end;
       end  { end model_type = SMPTOX }
  end; { end do_observed }

  { ------------------------------------------------------------------------- }
  { -- edit_river_data initializes variables and calls edit_screen to edit -- }
  { -- variables associated with river parameters --------------------------- }
  { ------------------------------------------------------------------------- }

	procedure edit_river_data;
	var xx : real;
		j, i : integer;
	old_l  : integer;
	begin
			 if MaxAvail <= sizeof(screen_inputs) then
			 begin
						Error_message('Out of Memory');
						exit;
			 end;

       new(screen_data);
       Screen_Type := Info_Screen;
       xpos := 1; ypos := 1;

       While (Screen_Type <> Escape) and (Screen_Type <> Quit_Input) do
       begin
            case Screen_Type of

            Info_Screen:
            begin
                 clear_screen_inputs;
                 Header_width := 1;
                 xheaders[0] := 'Requested Information';
                 xheaders[1] := 'Value';
                 yheaders[1] := 'Name of receiving stream             ';
                 yheaders[2] := 'Model Complexity (1,2,3)             ';
								 yheaders[3] := 'Number of discharges  (max = 40)     ';
								 yheaders[4] := 'Number of reaches  (max = 40)        ';
                 yheaders[5] := 'Name of pollutant                    ';
                 yheaders[6] := 'Pollutant concentration units        ';
                 yheaders[7] := 'Run title for screen display         ';
                 yheaders[8] := 'Type of Printer (FX,LQ,LJ)           ';
                 yheaders[9] := 'Printer Graph Quality (Low,Med,High) ';

                 xdata_width[0] := length(yheaders[1])+1;
                 xdata_width[1] := 77-xdata_width[0];

                 number_inputs[1][1] := FALSE;
                 number_inputs[1][2] := FALSE;
                 number_inputs[1][5] := FALSE;
                 number_inputs[1][6] := FALSE;
                 number_inputs[1][7] := FALSE;
                 number_inputs[1][8] := FALSE;
                 number_inputs[1][9] := FALSE;

                 set_normal_returns;
                 screen_data^[1,1] := Stream_Name;
(*                 if model_type = SMPTOX3 then
                    screen_data^[1,2] := 'SMPTOX3, TWO PHASE w/ BED SOLIDS'
                 else if model_type = SMPTOX2 then
                      screen_data^[1,2] := 'SMPTOX2, TWO PHASE w/o BED SOLIDS'
                 else screen_data^[1,2] := 'SMPTOX, SINGLE PHASE w/o BED SOLIDS';
*)
                 if model_type = SMPTOX3 then
                    screen_data^[1,2] := '3'
                 else if model_type = SMPTOX2 then
                      screen_data^[1,2] := '2'
                 else screen_data^[1,2] := '1';

                 str(Number_discharges,screen_data^[1,3]);
                 str(Number_reaches,screen_data^[1,4]);
                 screen_data^[1,5] := Pollutant_name;
                 screen_data^[1,6] := pollutant_units;
                 screen_data^[1,7] := Display_title;
                 screen_data^[1,8] := Printer_name;
                 screen_data^[1,9] := Printer_res;

                 old_l := model_type;
		 Screen_Type:=edit_screen('RUN INFORMATION',1,9,TRUE,xpos,ypos);
		 if Screen_Type <> ESCAPE then
		 begin
		      Stream_Name := rj(screen_data^[1,1]);
		      buf := Upstring(rj(screen_data^[1,2]));
		      val(screen_data^[1,3],Number_discharges,i);
		      val(screen_data^[1,4],Number_reaches,i);
		      Pollutant_name := rj(screen_data^[1,5]);
		      pollutant_units := rj(screen_data^[1,6]);
		      Display_title := rj(screen_data^[1,7]);
		      Printer_name := Upstring(rj(screen_data^[1,8]));
		      Printer_res := Upstring(rj(screen_data^[1,9]));

		      if pos('2',buf) > 0 then model_type := SMPTOX2
		      else if pos('3',buf) > 0 then model_type := SMPTOX3
		      else model_type := SMPTOX1;

		      if (old_l <> SMPTOX3) and (model_type = SMPTOX3) then
		         for i:=0 to number_reaches do
				if h[1,i] > 0 then ws[i] := ws[i] * h[1,i] * feet_to_meters;

		      if (old_l = SMPTOX3) and (model_type <> SMPTOX3) then
				for i:=0 to number_reaches do
				    if h[1,i] > 0 then ws[i] := ws[i] / (h[1,i] * feet_to_meters);

		      buf := Upstring(pollutant_units);

		      old_factor := scaling_factor;

		      if (pos('MG',buf)  > 0) or
			       (pos('PPM',buf) > 0) then
			       scaling_factor := 1000.0
		      else
		      if (pos('UG',buf)  > 0) or
			       (pos('PPB',buf) > 0) then
			       scaling_factor := 1000000.0
		      else
		      if (pos('NG',buf)  > 0) or
			       (pos('PPT',buf) > 0) then
			       scaling_factor := 1000000000.0
		      else
		      if (pos('PG',buf)  > 0) or
			       (pos('PPQ',buf) > 0) then
			       scaling_factor := 1000000000000.0
		      else
		      begin
			   error_message('Pollutant Units are mg/L or ug/L or ng/L or pg/L');
                           Screen_type := Info_Screen;
		      end;

		      if( old_factor <> 0) and (scaling_factor <> old_factor) then
		      begin
			   xx := scaling_factor / old_factor;

			   for i:=0 to number_reaches do
			       ad[i] := ad[i] * xx;
			   ct[1,0] := ct[1,0] * xx;

			   for i:=0 to number_reaches do
			       dt[1,i] := dt[1,i] * xx;

			   for i:= 0 to max_observations do
                           begin
			        for j:=1 to 5 do
				   observations[j,i] := observations[j,i] * xx;
                                if scaling_factor < 2000.0 then
                                   observations[6,i] := (observations[2,i] - observations[4,i]) *1000.0
                                                     / m[2,reach]  { for ug / mg }
                                else if scaling_factor < 2000000.0 then
                                   observations[6,i] := (observations[2,i] - observations[4,i])
                                                     / m[2,reach]  { for ug / mg }
                                else if scaling_factor < 2000000000.0 then
                                   observations[6,i] := (observations[2,i] - observations[4,i])
                                                     / (1000.0 * m[2,reach])  { for ug / mg }
                                else
                                   observations[6,i] := (observations[2,i] - observations[4,i])
                                                     / (m[2,reach]);  { for pg / mg }
                           end;
		      end;

                      if (Printer_name <> 'EPSON FX, (9 pin)') and
                         (Printer_name <> 'EPSON LQ, (24 pin)') and
                         (Printer_name <> 'HEWLETT PACKARD LASERJET') and
                         (Printer_name <> 'NONE') then
                      begin
                           if (pos('NO',Printer_name) > 0) then
                                Printer_name := 'NONE'
                           else
                           if (pos('LJ',Printer_name) > 0) or
                              (pos('LASER',Printer_name) > 0) or
                              (pos('HP',Printer_name) > 0) then
                                Printer_name := 'HEWLETT PACKARD LASERJET'
                           else
                           if (pos('LQ',Printer_name) > 0) or
                              (pos('24',Printer_name) > 0) then
                                Printer_name := 'EPSON LQ, (24 pin)'
                           else
                           if (pos('FX',Printer_name) > 0) or
                              (pos('9',Printer_name) > 0) then
                                Printer_name := 'EPSON FX, (9 pin)'
                           else
                           begin
                                error_message('Printer Types are "NONE", "FX", "LQ", "LJ"');
                                Screen_type := Info_Screen;
                           end;
                      end;

                      if (Printer_res <> 'LOW') and
                         (Printer_res <> 'MEDIUM') and
                         (Printer_res <> 'HIGH') and
                         (Printer_res <> 'NONE') then
                      begin
                           if pos('LO',Printer_res) > 0 then
                              Printer_res := 'LOW'
                           else
                           if pos('MED',Printer_res) > 0 then
                              Printer_res := 'MEDIUM'
                           else
                           if pos('HI',Printer_res) > 0 then
                              Printer_res := 'HIGH'
                           else
                           if pos('NO',Printer_res) > 0 then
                              Printer_res := 'NONE'
                           else
                           begin
                                error_message('Printer Resolutions are "NONE", "LOW", "MED", "HIGH"');
                                Screen_type := Info_Screen;
                           end;
                      end;

                      if (Number_reaches > Max_reaches) or (Number_reaches < 1) then
                      begin
													 error_message('Number of Reaches must be at least 1 and no more than 40');
                           Screen_type := Info_Screen;
                      end;
                      if Number_discharges > Number_reaches then
                      begin
                           error_message('Number of Discharges may not exceed Number of Reaches');
                           Screen_type := Info_Screen;
                      end;
                      if Number_discharges < 1 then
                      begin
                           error_message('There must be at least one Discharger');
                           Screen_type := Info_Screen;
                      end;
                 end;
            end;  { end info_screen }
            Upstream_Screen :
                begin
                     do_upstream;
                end;   { end Upstream_Screen}

            Effluent_Screen :
                begin
                     do_effluent;
                end;   { End Effluent_Screen}

            Reach_Screen :
                begin
                     do_reach;
                end;   { End Reach_Screen }

            Observed_Screen :
                begin
                		 do_observed;
                end;   { End Observed_Screen}
            end;  { end case }
       end; { end while }
       dispose(screen_data);
  end; { end edit_river_data }


  { --------------------------------------------------------------------------- }
  { --- View_table_output lets the user view the output contained in graph_buf[1] - }
  { --------------------------------------------------------------------------- }


  procedure view_table_output(out_file:textstr);
  var i,j,ii,x,y : integer;
      inn :text;
      line :string[255];
      buf_count,scr_count,t_count : integer;

	procedure xhead;
	var i : integer;
	begin
	     if model_type = SMPTOX3 then
	     begin
		  xheaders[0] := 'Mile ';
                  xheaders[1] := 'Total Water '+Pollutant_name+ ' '+Pollutant_units;
		  xheaders[2] := 'Total Bed '+Pollutant_name+ ' '+Pollutant_units;
		  xheaders[3] := 'Dis Water '+Pollutant_name+ ' '+Pollutant_units;
		  xheaders[4] := 'Dis Bed '+Pollutant_name+ ' '+Pollutant_units;
		  xheaders[5] := 'Par Water '+Pollutant_name+ ' '+Pollutant_units;
                  if scaling_factor < 2000000000 then
		     xheaders[6] := 'Par Bed '+Pollutant_name+ ' ug/mg'
                  else
		     xheaders[6] := 'Par Bed '+Pollutant_name+ ' pg/mg';
		  xheaders[7] := 'Suspend Solids mg/L';
		  header_width := 3;

       		  xdata_width[0] := 6;
       		  xdata_width[1] := 12;
       		  for i:=2 to 6 do
           		xdata_width[i] := 10;
       		  xdata_width[7] := 9;
	     end { end model_type = SMPTOX3 }
	     else
	     if model_type = SMPTOX2 then
	     begin
       	          xheaders[0] := 'Mile ';
       		  xheaders[1] := 'Total Water '+Pollutant_name+ ' '+Pollutant_units;
       		  xheaders[2] := 'Dis Water '+Pollutant_name+ ' '+Pollutant_units;
       		  xheaders[3] := 'Par Water '+Pollutant_name+ ' '+Pollutant_units;
       		  xheaders[4] := 'Suspend Solids mg/L';
       		  header_width := 2;

       		  xdata_width[0] := 6;
       		  for i:=1 to 4 do
           	      xdata_width[i] := 17;
	     end  { end model_type = SMPTOX2 }
	     else
	     begin
       		  xheaders[0] := 'Mile ';
       		  xheaders[1] := 'Total Water '+Pollutant_name+ ' '+Pollutant_units;
       		  header_width := 1;

       		  xdata_width[0] := 6;
		  xdata_width[1] := 68;
	     end; { end model_type = SMPTOX }
	end;

  begin
       if MaxAvail <= sizeof(screen_inputs) then
       begin
            Error_message('Out of Memory');
            exit;
       end;
       new(screen_data);
       Screen_Type := Output_Screen;
       clear_screen_inputs;
       x := 1; y := 1;
       no_move := true;

			 
       valid_returns[Page_up] := TRUE;
       valid_returns[Page_down] := TRUE;
       Valid_returns[quit_input] := TRUE;


       buf_count := 0;

       while (screen_type <> Quit_Input) and (screen_type <> Escape) do
       begin
            xhead;
	    screen_type := Output_screen;

            scr_count := 1;

            while scr_count <= 15 do
            begin
                 set_point(graph_buf[1]^[0,buf_count+scr_count-1],yheaders[scr_count]);
                 for i := 1 to 7 do
                     set_point(graph_buf[1]^[i,buf_count+scr_count-1],screen_data^[i,scr_count]);
		 if model_type = SMPTOX2 then
		 begin
		      screen_data^[2,scr_count] := screen_data^[3,scr_count];
		      screen_data^[3,scr_count] := screen_data^[5,scr_count];
		      screen_data^[4,scr_count] := screen_data^[7,scr_count];
		 end;
                 scr_count := scr_count + 1;
                 t_count := t_count + 1;
            end;
						
            if model_type = SMPTOX3 then
            	screen_type := edit_screen('OUTPUT DATA:  '+display_title,7,15,FALSE,x,y)
            else if model_type = SMPTOX2 then
            	screen_type := edit_screen('OUTPUT DATA:  '+display_title,4,15,FALSE,x,y)
            else 
            	screen_type := edit_screen('OUTPUT DATA:  '+display_title,1,15,FALSE,x,y);

            case screen_type of

                 page_up:
                 begin
                      buf_count := buf_count - 15;
                      if buf_count < 0 then
                         buf_count := 0;
                 end;


                 page_down:
                 begin
                      buf_count := Buf_count + 15;
                      if buf_count > last_buf-15 then
                         buf_count := LAST_BUF-15;
                 end;
            end;  { end case }

       end; { end while }
       dispose(screen_data);
  end; { end view_table }



  { ------------------------------------------------------------------- }
  { --- Edit_Sense allows the user to enter sensitivty analysis data -- }
  { ------------------------------------------------------------------- }

  function  edit_sense : integer;
  var i,ii,j,x,y : integer;
  begin
       if MaxAvail <= sizeof(screen_inputs) then
       begin
            Error_message('Out of Memory');
            edit_sense := ESCAPE;
            exit;
       end;
       new(screen_data);
       x := 1; y := 1;
       Screen_Type := sense_Screen;
       clear_screen_inputs;
       Header_width := 1;
       xheaders[0] := 'Parameter';
       xheaders[1] := 'Change (%)';

       if model_type = SMPTOX3 then
       begin
            yheaders[1] := 'Velocity                                ';
	    yheaders[2] := 'Average Depth                           ';
	    yheaders[3] := 'Active Bed Depth                        ';
	    yheaders[4] := 'Water Column Decay Rates                ';
	    yheaders[5] := 'Volatilization                          ';
	    yheaders[6] := 'Bed Decay Rates                         ';
	    yheaders[7] := 'Suspended Solids Settling Velocity      ';
	    yheaders[8] := 'Suspended Solids Resuspension Velocity  ';
	    yheaders[9] := 'Water Column Partition Coefficient      ';
	    yheaders[10] := 'Bed Partition Coefficient               ';
	    yheaders[11] := 'Diffusive Exchange Coefficient          ';
	    yheaders[12] := 'Bed Solids Concentration                ';
	    yheaders[13] := 'Upstream Toxicant Concentration         ';
	    yheaders[14] := 'Upstream Suspended Solids Concentration ';
       end { end model_type = SMPTOX3 }
       else
       if model_type = SMPTOX2 then
       begin
	    yheaders[1] := 'Velocity                                ';
	    yheaders[2] := 'Total Decay Rate                        ';
	    yheaders[3] := 'Suspended Solids Settling Rate          ';
	    yheaders[4] := 'Partition Coefficient                   ';
	    yheaders[5] := 'Upstream Toxicant Concentration         ';
	    yheaders[6] := 'Upstream Suspended Solids Concentration ';
       end { end model_type SMPTOX2 }
       else
       begin
	    yheaders[1] := 'Velocity                                ';
	    yheaders[2] := 'Total Loss                              ';
	    yheaders[3] := 'Upstream Toxicant Concentration         ';
       end;

       xdata_width[0] := length(yheaders[1])+1;
       xdata_width[1] := 77-xdata_width[0];

       valid_returns[quit_input] := TRUE;
       valid_returns[Escape] := TRUE;
       for i := 1 to 14 do
           set_point(sense_out[i],screen_data^[1,i]);

       if model_type = SMPTOX3 then
	  j:=edit_screen('SENSITIVITY ANALYSIS:  '+display_title,1,14,FALSE,x,y)
       else
       if model_type = SMPTOX2 then
       begin
	    screen_data^[1,2] := screen_data^[1,4];
	    screen_data^[1,3] := screen_data^[1,7];
	    screen_data^[1,4] := screen_data^[1,9];
	    screen_data^[1,5] := screen_data^[1,13];
	    screen_data^[1,6] := screen_data^[1,14];
	    j:=edit_screen('SENSITIVITY ANALYSIS:  '+display_title,1,6,FALSE,x,y);
       end
       else
       begin
	    screen_data^[1,2] := screen_data^[1,4];
	    screen_data^[1,3] := screen_data^[1,13];
	    j:=edit_screen('SENSITIVITY ANALYSIS:  '+display_title,1,3,FALSE,x,y);
       end;


       if j <> ESCAPE then
       begin
	    if model_type = SMPTOX3 then
	    begin
		 for i := 1 to 14 do
		     val(screen_data^[1,i],sense_out[i],ii);
	    end
	    else
	    if model_type = SMPTOX2 then
	    begin
		 val(screen_data^[1,1],sense_out[1],ii);
		 val(screen_data^[1,2],sense_out[4],ii);
		 val(screen_data^[1,3],sense_out[7],ii);
		 val(screen_data^[1,4],sense_out[9],ii);
		 val(screen_data^[1,5],sense_out[13],ii);
		 val(screen_data^[1,6],sense_out[14],ii);
	    end
	    else
	    begin
		 val(screen_data^[1,1],sense_out[1],ii);
		 val(screen_data^[1,2],sense_out[4],ii);
		 val(screen_data^[1,3],sense_out[13],ii);
	    end;
       end;  { end j <> escape }

       dispose(screen_data);
       edit_sense := j;
  end;  { end sense_screen }

  { ------------------------------------------------------------------------ }
  { --- modify_discharge allows the user to enter wla standard and modify -- }
  { --- the effluent volume without reentering the edit screen.  This ------ }
  { --- procedure does not rely on scrnutil because of its specialized ----- }
  { --- nature.  It returns escape if escape was pressed, otherwise 1. ----- }
  { ------------------------------------------------------------------------ }

  function mod_dis : integer;
  var i,j : integer;
  x,y : integer;
  begin
       if MaxAvail <= sizeof(screen_inputs) then
       begin
            Error_message('Out of Memory');
            mod_dis := ESCAPE;
            exit;
       end;
       new(screen_data);
       x := 1; y := 1;
       Screen_Type := sense_Screen;
       clear_screen_inputs;
       Valid_returns[quit_input] := TRUE;
       Header_width := 1;
       xheaders[0] := ' ';
       xheaders[1] := 'Standard (' + Pollutant_units + ')';
       xheaders[2] := 'From Mile';
       xheaders[3] := 'To Mile';

       xdata_width[0] := 2;
       xdata_width[1] := 45;
       xdata_width[2] := 15;
       xdata_width[3] := 15;

       for i := 1 to Max_Standards do
           str(i,yheaders[i]);

       for j := 0 to 2 do
	  for i := 1 to Max_Standards do
		set_point(standard[j,i],screen_data^[j+1,i]);

       j:=edit_screen('Select Standards',3,Max_Standards,FALSE,x,y);
       if j <> ESCAPE then
       begin
	    for j := 0 to 2 do
		for i := 1 to Max_Standards do
		    val(screen_data^[j+1,i],standard[j,i],x);
       end
       else
       begin
            dispose(screen_data);
            mod_dis := j;
            exit;
       end;

       x := 1; y := 1;
       Screen_Type := sense_Screen;
       clear_screen_inputs;
       Valid_returns[quit_input] := TRUE;
       Header_width := 1;
       xheaders[0] := ' Discharge Name ';
       xheaders[1] := Pollutant_name + ' ' + Pollutant_units;

       xdata_width[0] := 30;
       xdata_width[1] := 47;

       for i := 1 to number_discharges do
       begin
            yheaders[i] :=  facility_name[discharge_number[i]];
	    set_point(dt[1,discharge_number[i]],screen_data^[1,i]);
       end;

       j:=edit_screen('Select Standards',1,Number_discharges,FALSE,x,y);

       if j <> ESCAPE then
       begin
            for i := 1 to number_discharges do
	    val(screen_data^[1,i],dt[1,discharge_number[i]],x);
       end;
       mod_dis := j;
       dispose(screen_data);
  end; { end mod_dis }

  function modify_discharge : integer;
  type dd = array[1..2,1..3,1..max_reaches] of sfields;
  var i,j,g,k,ii  : integer;
      di,dj,dg    : integer;
      group       : integer;
      coll        : integer;
      roww        : integer;
      buf         : string;
      xcol        : array[1..2,1..3] of integer;
      xwidth      : array[1..2,1..3] of integer;
      datums      : ^dd;

  procedure showcell(g,i,j : integer; s: state);
  var k : integer;
  begin
       datums^[g,i,j] := rj(datums^[g,i,j]);
       k := trunc( (xwidth[g,i]- length(datums^[g,i,j]) ) /2);
       while k > 0 do
       begin
            datums^[g,i,j] := ' ' + datums^[g,i,j];
            k := k -1;
       end;

       if g = 1 then k := 3+j
       else k := 10 + Max_standards + j;
       showstring(datums^[g,i,j],xcol[g,i],k,xwidth[g,i],s);
  end;

  begin { modify_discharge }
        if number_discharges > 10 then
	begin
	     modify_discharge := mod_dis;
	     exit;
	end;

	ClearScreen;
	if MaxAvail <= sizeof(dd) then
	begin
	     Error_message('Out of Memory');
	     modify_discharge := ESCAPE;
	     exit;
	end;
	new(datums);

       for j := 1 to 2 do
       for i:= 0 to max_reaches do
           original_dt[j,i] := dt[j,i];

       linetype := 2;
       textbox(3,1,4+max_standards,79);
       textbox(1,1,3,79);

       buf := 'Standard (' + Pollutant_units + ')';
       i := length(buf);
       showstring(Buf,3,2,i,off);
       if i >= 24 then i := i +2
       else i := 25;
       xwidth[1,1] := i - 2;
       xcol[1,1] := 2;
       linetype := 1;
       textLineV(i,1,4+Max_standards);

       xcol[1,2] := i + 1;
       buf := 'From Mile';
       showstring(Buf,xcol[1,2]+7,2,10,Off);
       xwidth[1,2] := 23;
       textlineV(xcol[1,2] + xwidth[1,2],1,4+Max_standards);

       xcol[1,3] := xcol[1,2] + xwidth[1,2] + 1;
       buf := 'To Mile';
       showstring(Buf,xcol[1,3]+10,2,9,Off);
       xwidth[1,3] := 79 - xcol[1,3];

       linetype := 2;
       textbox(10+Max_standards,1,11+Max_standards+number_discharges,79);
       textbox(8+Max_Standards,1,10+Max_standards,79);

       buf := 'Name of Discharge';
       showstring(Buf,3,9+Max_standards,15,off);
       xwidth[2,1] := xwidth[1,1];
       xcol[2,1] := 2;
       linetype := 1;
       textLineV(i,8+Max_standards,11+Max_standards+number_discharges);

       xcol[2,2] := 1 +  xwidth[2,1] + xcol[2,1];
       xwidth[2,2] := 78 - xcol[2,2];
       buf := 'Total ' + Pollutant_name + ' Discharge  (' + Pollutant_units+')';
       showstring(buf,xcol[2,2]+10,9+Max_standards,20,off);

       if standard[1,1] = 0.0 then
       begin
            standard[0,1] := 10.5;
            standard[1,1] := upstream_river_mile;
            standard[2,1] := upstream_river_mile;
            for i := 1 to number_reaches do
                standard[2,1] := standard[2,1] - r_length[i];
       end;

       for j := 0 to 2 do
           for i := 1 to Max_Standards do
               set_point(standard[j,i],datums^[1,j+1,i]);

       for i := 1 to number_discharges do
       begin
            datums^[2,1,i] := facility_name[discharge_number[i]];
            set_point(dt[1,discharge_number[i]],datums^[2,2,i]);
       end;

       TextLineH(25,2,79);
       showstring('Enter text and Press     to continue',23,25,34,off);
       showstring('F10',44,25,3,ON);
       for i := 1 to 3 do
           for j := 1 to Max_standards do
               showcell(1,i,j,Off);

       for i := 1 to 2 do
           for j := 1 to number_discharges do
               showcell(2,i,j,Off);

       code := 1;
       g := 1;  i := 1; j := 1;

       while (code <> -68) and (code <> 27) do
       begin
            showcell(g,i,j,on);
            di := 0; dj := 0; dg := 0;
            getchar;
            if (Code > 32) and (Ch in ['0'..'9','-','+','.']) then
            begin
                 if g = 1 then k := 3+j
                 else k := 10 + Max_standards + j;
                 GetString(Buf,xcol[g,i],k,xwidth[g,i]-1,['0'..'9','+','-','.']);
                 if Code <> 27 then
                 begin
                      k := trunc( (xwidth[g,i] - length(buf) -1) / 2);
                      for ii := 1 to k do
                          buf := ' ' + buf;
                      datums^[g,i,j] := buf;
                 end;
            end;
            case code of
                 13 : DJ := 1;
                 -72: DJ := -1;
                 -75: DI := -1;
                 -77: DI := 1;
                 -80: DJ := 1;
            end;
            if g = 1 then
            begin
                 if di < 0 then if i = 1 then di := 0;
                 if di > 0 then if i = 3 then di := 0;
                 if dj < 0 then if j = 1 then dj := 0;
                 if dj > 0 then if j = max_standards then
                 begin
                      di := 2 - i;
                      dj := 1 - j;
                      dg := 1;
                 end;
            end
            else
            begin
                 di := 0;
                 if dj > 0 then if j >= number_discharges then dj := 0;
                 if dj < 0 then if j = 1 then
                 begin
                      di := 1 - i;
                      dj := max_standards - j;
                      dg := -1;
                 end;
            end;
            if (di <> 0 ) or (dj <> 0) or (dg <> 0) then
            begin
                 showcell(g,i,j,off);
                 i := i + di;
		 j := j + dj;
                 g := g + dg;
                 showcell(g,i,j,on);
            end;
       end;

       if Code = 27 then
       begin
            modify_discharge := Escape;
            dispose(datums);
            exit;
       end;

      for i := 1 to number_discharges do
          val(datums^[2,2,i],dt[1,discharge_number[i]],ii);
      for i := 1 to 3 do
          for j := 1 to max_standards do
              val(datums^[1,i,j],standard[i-1,j],ii);

      dispose(datums);
      for j := 0 to max_standards-1 do
           if (standard[0,j] <> 0) and ((standard[1,j] = 0)
           or (standard[2,j] = 0)) then
      begin
            standard[1,j] := upstream_river_mile;
            standard[2,j] := upstream_river_mile;
            for i := 1 to number_reaches do
                standard[2,j] := standard[2,j] - r_length[i];
      end;

      modify_discharge := quit_input;
  end;

  { ------------------------------------------------------------ }
  { --- unmodify_discharge returns dt to its origianl values --- }
  { ------------------------------------------------------------ }

  procedure unmodify_discharge;
  var i,j : integer;
  begin
       for j := 1 to 2 do
       for i := 0 to max_reaches do
           dt[j,i] := original_dt[j,i];
  end;  { end unmodify_discharge }

end. { end implementation }