{ -------------------------------------------------------------------------- }
{ -- The following file contains global variables for the SMPTX3 model ----- }
{ -- This file should be used by all other SMPTX3 units  ------------------- }
{ -------------------------------------------------------------------------- }


{ ----------------------- Created 5/24/90 by DC ---------------------------- }
{ ------------------------- Modification lists ----------------------------- }

{ 6/1/90   Added Misc variables - DC }
{ 6/8/90   Adding suspended solids to disk buffer, adding total q - DC }
{ 6/12/90  Removed r unused - DC }
{ 6/14/90  Added Observations - DC }
{ 7/2/90   Added variable to store graph type - DC }
{ 7/3/90   Added variable to store standard - DC }
{ 7/10/90  Lowering Disk_Buffer_Size as it is theoritically never used - DC }
{ 7/10/90  Adding room for analytical solution - DC }
{ 8/1/90   Adding room for multiple facility names - DC }
{ 10/19/90 Breaking Miscellaneous data into new module - DC }
{ 1/3/91   Adding modeling complexity constants - DC }
{ 1/25/91  Attempting to make multiple reach version - DC }

{ -------------------------------------------------------------------------- }
{ -------------------------------------------------------------------------- }
unit stx3_var;

interface

uses crt,textutil;


Const

Max_Reaches = 40;          { Maximum number of reaches }
Max_standards = 3;         { Maximum number of standards }
Max_Observations = 50;     { Maximum number of observed data points }
Max_buffer_size = 300;     { needed for disk buffer }
Max_Graph_size = 100;      { Number of points to Graph }

miles_to_meters = 1609.344; { Conversion constant }
feet_to_meters = 0.3048;    { Conversion Constant }
secs_per_day = 86400;       { Conversion Constant }
cfs_to_ls = 28.316847;      { Conversion Constant }
mgd_to_ls = 43.812636;      { Conversion Constant }


In_Put = 1;                { Used to pass to get_file_name }
Out_Put = 2;               { Used to Pass to get_file_name }
Out_Print = 3;             { Used to Pass to get_file_name }

Observation_Plot = 1;      { Used to Pass to show_graph }
WLA_Plot         = 2;      { Used to Pass to Show_graph }
Sensitivity_Plot = 3;      { Used to Pass to Show_Graph }
Many_plot        = 4;      { Used to Pass to Show_Graph }

Max_graphs       = 11;      { Maximum number of graphs on one screen }

SMPTOX3          = 3;      { Used to determine modelling complexity }
SMPTOX2          = 2;      { Used to determine modelling complexity }
SMPTOX1          = 1;      { Used to determine modelling complexity }


type
 real = system.double;   { forces 8087 }

global_var = array[1..2,0..Max_Reaches] of real;   { [1] = water column, [2] = Sediment }
reach_var = array[0..Max_Reaches] of real;
graphics_buffer = array[0..8,0..max_buffer_size] of real;


var
      { Concentrations }
ct  : global_var;                             { Total toxicant (ug/l) }
dt  : global_var;                             { Discharged toxicant (ug/l) }
cd  : global_var;                             { Dissolved toxicant (ug/l) }
cp  : global_var;                             { Particulate toxicant (ug/l) }
m   : global_var;                             { total solids (mg/l) }
wt  : reach_var;                              { toxicant load (kg/day) }

      { Partitioning }
fd  : global_var;                             { Dissolved fraction }
fp  : global_var;                             { particulate fraction }
pc  : global_var;                             { partition coefficient (l/mg) (pc = r/cd) }

      { Channel Geometry }
a   : reach_var;                              { Cross-Sectional area (m*m) }
h   : global_var;                             { depth (ft) }
q   : reach_var;                              { flow (l/sec) }
u   : reach_var;                              { velocity (ft/sec) (u=q/a) }

      { Rate Parameters }
kd  : global_var;                { Aggregate decay rate coefficient (1/day) - for dissolved }
kp  : global_var;                {           - for particulate }
k   : global_var;                {           - for total (k=kd*fd + kp*fp }
vl  : reach_var;                 { Volatiluzation (1/day) }
ws  : reach_var;                 { Settling velocity (m/day) }
wrs : reach_var;                 { Resuspension velocity (m/day) }
wd  : reach_var;                 { Sedimentation (burial) velocity (m/day) }
ks  : reach_var;                 { Sedimentation loss coefficient (1/day) }
kl  : reach_var;                 { Diffusive exchange coefficient (m/day) }
ad  : reach_var;                 { Atmospheric Deposition (g/mile/day) }

implementation
end.
