{ =============================================== }
{                                                 }
{    UTIL.PAS - Turbo Pascal utility routines     }
{               for text screens                  }
{                                                 }
{           Written by Tad Slawecki               }
{                                                 }
{ =============================================== }

unit TextUtil;

interface


uses crt, dos;


const

Double = 2;            {TextLine types}
Single = 1;


type

MenuStr   = string[255];
TextStr   = string[80];
State     = (On,Off);
ASCII     = set of Char;
TLScreen  = array[81..2080] of byte;


var

LastPrompt: TextStr;

AsciiToL : array[0..255] of byte;
LtoAscii : array[0..255] of byte;
Screen   : TLScreen;
LineType : integer;
Spot     : integer;

Reg      : Registers;           { 8088 Registers for interrupts }

Code     : integer;            { Extended ASCII of last keypress }
Ch       : char;               { Character value of last keypress }

CursorLines: integer;     { Cursor scan lines }


procedure NormVideo;
procedure InvVideo;
procedure Cursor(Cstate: state);
procedure GetChar;
procedure ClearScreen;
procedure TextClear(R1,C1,R2,C2: integer);
function  Spurs(var Row, Col: integer): byte;
procedure TextLineV(Col, Row1, Row2: integer);
procedure TextLineH(Row, Col1, Col2: integer);
procedure TextBox(Row1,Col1,Row2,Col2: integer);
function  Modulus(A,B: integer): integer;
procedure GetString(var Input: string; X,Y,L: integer; CharSet: ASCII);
procedure ShowString(S: TextStr; X,Y,L: Integer; SState: state);
procedure Prompt(What: TextStr);
procedure Error_Message(What: TextStr);
procedure GetMenuChoice(var M: integer; ChoiceString: MenuStr);

{ =============================================== }

implementation


{ =============================================== }

procedure NormVideo;

begin

  TextColor(14);
  TextBackground(1);
  end;

{ =============================================== }

procedure InvVideo;

begin

  TextColor(0);
  TextBackground(7);
  end;

{ =============================================== }

procedure Cursor(Cstate: state);

begin

  Reg.AX := $0100;
  if Cstate = on
     then Reg.CX := CursorLines
     else Reg.CX := (CursorLines and $CFFF) or $2000;

  Intr($10,Reg);
  end;

{ =============================================== }

procedure GetChar;

begin

  ch := readkey;
  if KeyPressed and (Ch = #0)
     then begin

       ch   := readkey;
       Code := -Ord(Ch);
       end

     else Code := Ord(Ch);

  end;

{ =============================================== }

procedure ClearScreen;

var I: integer;

begin

  NormVideo;
  ClrScr;
  FillChar(Screen,2000,0);
  lastprompt := '';
  Cursor(Off);
  end;

{ =============================================== }

procedure TextClear(R1,C1,R2,C2: integer);

var R: integer;

begin

  NormVideo;
  Window(C1,R1,C2,R2); ClrScr; Cursor(Off);
  Window(1,1,80,25);

  for R := R1 to R2 do
      FillChar(Screen[R*80+C1],(C2-C1+1) shl 1,0);

  end;

{ =============================================== }

function Spurs(var Row, Col: integer): byte;

var Above, Below, Left, Right: byte;

begin

  Spot  := 80 * Row + Col;

  if Row = 25
     then Below := 0
     else Below := (AsciiToL[Screen[Spot + 80]] and 196) shr 6;

  if Col = 1
     then Left  := 0
     else Left  := (AsciiToL[Screen[Spot -  1]] and 48) shr 2;

  if Col = 80
     then Right := 0
     else Right := (AsciiToL[Screen[Spot +  1]] and 12) shl 2;

  if Row = 1
     then Above := 0
     else Above := (AsciiToL[Screen[Spot - 80]] and 3) shl 6;

  Spurs := Above + Below + Left + Right;
  end;

{ =============================================== }

procedure TextLineV(Col, Row1, Row2: integer);

var

Row : integer;
Spur: integer;

begin

  for Row := Row1 to Row2 do
  begin

    Spur := Spurs(Row,Col);
    if (Row <> Row2) and ((Spur and LineType) = 0)
        then Spur := (Spur and 252) + LineType;
    GotoXY(Col,Row); Write(Char(LtoAscii[Spur]));
    Screen[Spot] := LtoAscii[Spur];
    end;

  end;

{ =============================================== }

procedure TextLineH(Row, Col1, Col2: integer);

var

Col : integer;
Spur: integer;

begin

  for Col := Col1 to Col2 do
  begin

    Spur := Spurs(Row,Col);
    if (Col <> Col2) and ((Spur and (LineType shl 4)) = 0)
       then Spur := (Spur and 207) + LineType shl 4;
    GotoXY(Col,Row); Write(Char(LtoAscii[Spur]));
    Screen[Spot] := LtoAscii[Spur];
    end;

  end;

{ =============================================== }

procedure TextBox(Row1,Col1,Row2,Col2: integer);

begin

  TextLineH(Row1,Col1,Col2);
  TextLineH(Row2,Col1,Col2);
  TextLineV(Col1,Row1,Row2);
  TextlineV(Col2,Row1,Row2);
  end;

{ =============================================== }

function Modulus(A,B: integer): integer;
begin

  if A > B
     then A := A - B
     else if A < 1
             then A := A + B;

  Modulus := A;
  end;

{ =============================================== }

procedure GetString(var Input: string; X,Y,L: integer; CharSet: ASCII);

var

Buffer: TextStr;
Blen  : byte absolute buffer;

  procedure Erase;
  begin

    InvVideo;
    GotoXY(X,Y); Write('':L);
    GotoXY(X,Y);
    Buffer := '';
    end;

begin

  Erase;
  Cursor(on);
  while (Code = -83) or (Code = 8) or (Code > 31) do
  begin

    case Code of

       -83: Erase;
         8: if BLen > 0
               then begin

                 GotoXY(WhereX-1,WhereY);
                 Write (' ');
                 GotoXY(WhereX-1,WhereY);
                 if Blen > 1
                    then Buffer := Copy (Buffer,1,Blen-1)
                    else Buffer := '';

                 end;

        else if (Ch in CharSet) and (BLen < L)
                then begin

                  Buffer := Buffer + Ch;
                  Write (Ch);
                  end;

       end;

    GetChar;
    end;

  Cursor(off);
  Input := Buffer;
  end;

{ =============================================== }

procedure ShowString(S: TextStr; X,Y,L: Integer; SState: state);
begin

  if SState = on
     then InvVideo
     else NormVideo;

  GotoXY(X,Y); Write('':L);
  GotoXY(X,Y); Write(S);
  end;

{ =============================================== }

procedure Prompt(What: TextStr);

begin

  if What <> ''
     then What := ' ' + What + ' ';

  if Length(What) < Length(LastPrompt)
     then begin

       NormVideo;
       LineType := Single;
       TextLineH(25,(78-Length(LastPrompt)) div 2,(82+Length(LastPrompt)) div 2);
       end;

  InvVideo; GotoXY((82 - Length(What)) div 2,25); Write(What);
  LastPrompt := What;
  end;

{ =============================================== }
procedure Error_Message(What: TextStr);
var i,j : integer;
begin
     NormVideo; ClearScreen;
     InvVideo;
     linetype := 1;
     textbox(1,1,25,79);
     linetype := 2;
     i := length(what);
     if i>75 then what := copy(what,1,74);
     i := trunc(length(what) /2);
     NormVideo;
     textbox(10,40-i-2,12,40+i+2);
     InvVideo;
     gotoXY(40-i,11);  write(what);
     normvideo;
     prompt('Press Any Key To Continue');
     getchar;
     normvideo;
     linetype := 1;
     for j := 1 to 3 do
     begin
          Gotoxy(40-i-2,9 + j);
          write('':2 * i + 5);
     end;
end;

{ =============================================== }
procedure GetMenuChoice(var M: integer; ChoiceString: MenuStr);

var

I,DI,Choices,Top,Left,Right,Len,Lines: integer;
CText   : array[0..15] of TextStr;
Separate: array[0..15] of Boolean;
Line    : array[0..15] of integer;

  procedure Show(I: integer; S: State);
  begin

    ShowString(CText[I],Left+6,Line[I],Len,S);
    end;

begin

  TextMode(C80); ClearScreen;

  Choices := 0;
  Len     := 0;
  while Length(ChoiceString) > 0 do
  begin

    I := Pos('/',ChoiceString);
    if I = 0
       then I := Length(ChoiceString) + 1;

    if I = 1
       then Separate[Choices - 1] := True
       else begin

         Separate[Choices] := False;
         CText[Choices] := ' ' + Copy(ChoiceString,1,I-1);
         if Len < Length(CText[Choices])
            then Len := Length(CText[Choices]);

         Choices := Choices + 1;
         end;

    ChoiceString := Copy(ChoiceString,I+1,255);
    end {While Length(ChoiceString) > 0};

  Choices := Choices - 1;
  Lines   := 0;
  for I := 1 to Choices do
  begin

    Lines := Lines + 2;
    Line[I] := Lines;
    end;

  Top   := 14 - Lines div 2;
  Left  := 36 - (Len div 2);
  Right := 44 + (Len div 2);

  if length(CText[0])>5
     then begin

       ClearScreen; Cursor(off);
{       LineType := Single; TextBox(1,1,25,79); }
       TextLineH(25,2,79);


       LineType := Double; TextBox(2,25,4,57);
       GotoXY((82 - Length(ctext[0])) div 2,3); Write(ctext[0]);
       end;

  TextBox(Top+1,Left,Top+Lines+1,Right);
  LineType := Single;
  for I := 1 to Choices do
  begin

    Line[I] := Line[I] + Top;
    Show(I,Off);
    GotoXY(Left+2-I div 10,WhereY);
    Write('[',I,']');
    if Separate[I]
       then TextLineH(WhereY+1,Left,Right);

    end {For I := ... };

  I := M;
  Code := 0;
  Show(I,on);

  Prompt('Make selection and press Enter');

  while (Code <> -68) and (Code <> 27) and (Code <> 13) do
  begin

    case Code of

      -71: DI :=  1 - I;
      -72: DI := -1;
      -79: DI :=  Choices - I;
      -80: DI :=  1;
{       13: DI :=  1; }

      else if (code < 0) or not (Code in [48..49 + Choices])
              then DI := 0
              else begin

                DI := Code - 48 - I;
                if DI <= 0
                   then if (I + DI + 10 <= Choices) and (DI > -10)
                           then DI := DI + 10;

                end;

      end {Case Code of ... };

    if DI <> 0
       then begin

         Show(I,Off);
         I := Modulus(I+DI,Choices);
         Show(I,On);
         end {If DI <> 0};

    GetChar;
    end {While Code <> -68};

  if Code = 27 then M := -1
  else M := I;
  end {GetMenuChoice};

{ =============================================== }

procedure Wait;
begin

 repeat

   GetChar
   until Code = -68;

 end;

{ =============================================== }

const

SpurDat: array[179..218] of byte =

( 65,  69,  73, 134,   6,   9, 138, 130,  10, 136,
 132,  72,   5,  80,  84,  21,  81,  20,  85,  97,
 146, 160,  34, 168,  42, 162,  40, 170, 104, 148,
  41,  22, 144, 96,   33,  18, 150, 105,  68,  17);

var I: integer;

begin

  FillChar(AsciiToL,256,$00);
  FillChar(LtoAscii,256,$FE);

  for I := 179 to 218 do
  begin

    AsciiToL[I] := SpurDat[I];
    LtoAscii[SpurDat[I]] := I;
    end;

  LtoAscii[1]   := 179;
  LtoAscii[2]   := 186;
  LtoAscii[4]   := 196;
  LtoAscii[8]   := 205;
  LtoAscii[16]  := 196;
  LtoAscii[32]  := 205;
  LtoAscii[64]  := 179;
  LtoAscii[128] := 186;

  LineType := 1;

  if (mem[0000:1040] and 16) <> 0      { Check which card is being used. }
     then CursorLines := $0C0D
     else CursorLines := $0607;

  ClearScreen;
  end.
